/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.EnabledProtocols;
import com.azure.resourcemanager.storage.models.FileSharePropertiesFileSharePaidBursting;
import com.azure.resourcemanager.storage.models.LeaseDuration;
import com.azure.resourcemanager.storage.models.LeaseState;
import com.azure.resourcemanager.storage.models.LeaseStatus;
import com.azure.resourcemanager.storage.models.RootSquashType;
import com.azure.resourcemanager.storage.models.ShareAccessTier;
import com.azure.resourcemanager.storage.models.SignedIdentifier;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class FileShareProperties
implements JsonSerializable<FileShareProperties> {
    private OffsetDateTime lastModifiedTime;
    private Map<String, String> metadata;
    private Integer shareQuota;
    private Integer provisionedIops;
    private Integer provisionedBandwidthMibps;
    private Integer includedBurstIops;
    private Long maxBurstCreditsForIops;
    private DateTimeRfc1123 nextAllowedQuotaDowngradeTime;
    private DateTimeRfc1123 nextAllowedProvisionedIopsDowngradeTime;
    private DateTimeRfc1123 nextAllowedProvisionedBandwidthDowngradeTime;
    private EnabledProtocols enabledProtocols;
    private RootSquashType rootSquash;
    private String version;
    private Boolean deleted;
    private OffsetDateTime deletedTime;
    private Integer remainingRetentionDays;
    private ShareAccessTier accessTier;
    private OffsetDateTime accessTierChangeTime;
    private String accessTierStatus;
    private Long shareUsageBytes;
    private LeaseStatus leaseStatus;
    private LeaseState leaseState;
    private LeaseDuration leaseDuration;
    private List<SignedIdentifier> signedIdentifiers;
    private OffsetDateTime snapshotTime;
    private FileSharePropertiesFileSharePaidBursting fileSharePaidBursting;

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public FileShareProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Integer shareQuota() {
        return this.shareQuota;
    }

    public FileShareProperties withShareQuota(Integer shareQuota) {
        this.shareQuota = shareQuota;
        return this;
    }

    public Integer provisionedIops() {
        return this.provisionedIops;
    }

    public FileShareProperties withProvisionedIops(Integer provisionedIops) {
        this.provisionedIops = provisionedIops;
        return this;
    }

    public Integer provisionedBandwidthMibps() {
        return this.provisionedBandwidthMibps;
    }

    public FileShareProperties withProvisionedBandwidthMibps(Integer provisionedBandwidthMibps) {
        this.provisionedBandwidthMibps = provisionedBandwidthMibps;
        return this;
    }

    public Integer includedBurstIops() {
        return this.includedBurstIops;
    }

    public Long maxBurstCreditsForIops() {
        return this.maxBurstCreditsForIops;
    }

    public OffsetDateTime nextAllowedQuotaDowngradeTime() {
        if (this.nextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedQuotaDowngradeTime.getDateTime();
    }

    public OffsetDateTime nextAllowedProvisionedIopsDowngradeTime() {
        if (this.nextAllowedProvisionedIopsDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedProvisionedIopsDowngradeTime.getDateTime();
    }

    public OffsetDateTime nextAllowedProvisionedBandwidthDowngradeTime() {
        if (this.nextAllowedProvisionedBandwidthDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedProvisionedBandwidthDowngradeTime.getDateTime();
    }

    public EnabledProtocols enabledProtocols() {
        return this.enabledProtocols;
    }

    public FileShareProperties withEnabledProtocols(EnabledProtocols enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    public RootSquashType rootSquash() {
        return this.rootSquash;
    }

    public FileShareProperties withRootSquash(RootSquashType rootSquash) {
        this.rootSquash = rootSquash;
        return this;
    }

    public String version() {
        return this.version;
    }

    public Boolean deleted() {
        return this.deleted;
    }

    public OffsetDateTime deletedTime() {
        return this.deletedTime;
    }

    public Integer remainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public ShareAccessTier accessTier() {
        return this.accessTier;
    }

    public FileShareProperties withAccessTier(ShareAccessTier accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public OffsetDateTime accessTierChangeTime() {
        return this.accessTierChangeTime;
    }

    public String accessTierStatus() {
        return this.accessTierStatus;
    }

    public Long shareUsageBytes() {
        return this.shareUsageBytes;
    }

    public LeaseStatus leaseStatus() {
        return this.leaseStatus;
    }

    public LeaseState leaseState() {
        return this.leaseState;
    }

    public LeaseDuration leaseDuration() {
        return this.leaseDuration;
    }

    public List<SignedIdentifier> signedIdentifiers() {
        return this.signedIdentifiers;
    }

    public FileShareProperties withSignedIdentifiers(List<SignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
        return this;
    }

    public OffsetDateTime snapshotTime() {
        return this.snapshotTime;
    }

    public FileSharePropertiesFileSharePaidBursting fileSharePaidBursting() {
        return this.fileSharePaidBursting;
    }

    public FileShareProperties withFileSharePaidBursting(FileSharePropertiesFileSharePaidBursting fileSharePaidBursting) {
        this.fileSharePaidBursting = fileSharePaidBursting;
        return this;
    }

    public void validate() {
        if (this.signedIdentifiers() != null) {
            this.signedIdentifiers().forEach(e -> e.validate());
        }
        if (this.fileSharePaidBursting() != null) {
            this.fileSharePaidBursting().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("shareQuota", (Number)this.shareQuota);
        jsonWriter.writeNumberField("provisionedIops", (Number)this.provisionedIops);
        jsonWriter.writeNumberField("provisionedBandwidthMibps", (Number)this.provisionedBandwidthMibps);
        jsonWriter.writeStringField("enabledProtocols", this.enabledProtocols == null ? null : this.enabledProtocols.toString());
        jsonWriter.writeStringField("rootSquash", this.rootSquash == null ? null : this.rootSquash.toString());
        jsonWriter.writeStringField("accessTier", this.accessTier == null ? null : this.accessTier.toString());
        jsonWriter.writeArrayField("signedIdentifiers", this.signedIdentifiers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("fileSharePaidBursting", (JsonSerializable)this.fileSharePaidBursting);
        return jsonWriter.writeEndObject();
    }

    public static FileShareProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FileShareProperties)jsonReader.readObject(reader -> {
            FileShareProperties deserializedFileShareProperties = new FileShareProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedFileShareProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedFileShareProperties.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("shareQuota".equals(fieldName)) {
                    deserializedFileShareProperties.shareQuota = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisionedIops".equals(fieldName)) {
                    deserializedFileShareProperties.provisionedIops = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisionedBandwidthMibps".equals(fieldName)) {
                    deserializedFileShareProperties.provisionedBandwidthMibps = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("includedBurstIops".equals(fieldName)) {
                    deserializedFileShareProperties.includedBurstIops = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxBurstCreditsForIops".equals(fieldName)) {
                    deserializedFileShareProperties.maxBurstCreditsForIops = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("nextAllowedQuotaDowngradeTime".equals(fieldName)) {
                    deserializedFileShareProperties.nextAllowedQuotaDowngradeTime = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("nextAllowedProvisionedIopsDowngradeTime".equals(fieldName)) {
                    deserializedFileShareProperties.nextAllowedProvisionedIopsDowngradeTime = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("nextAllowedProvisionedBandwidthDowngradeTime".equals(fieldName)) {
                    deserializedFileShareProperties.nextAllowedProvisionedBandwidthDowngradeTime = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("enabledProtocols".equals(fieldName)) {
                    deserializedFileShareProperties.enabledProtocols = EnabledProtocols.fromString(reader.getString());
                    continue;
                }
                if ("rootSquash".equals(fieldName)) {
                    deserializedFileShareProperties.rootSquash = RootSquashType.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedFileShareProperties.version = reader.getString();
                    continue;
                }
                if ("deleted".equals(fieldName)) {
                    deserializedFileShareProperties.deleted = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("deletedTime".equals(fieldName)) {
                    deserializedFileShareProperties.deletedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("remainingRetentionDays".equals(fieldName)) {
                    deserializedFileShareProperties.remainingRetentionDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("accessTier".equals(fieldName)) {
                    deserializedFileShareProperties.accessTier = ShareAccessTier.fromString(reader.getString());
                    continue;
                }
                if ("accessTierChangeTime".equals(fieldName)) {
                    deserializedFileShareProperties.accessTierChangeTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("accessTierStatus".equals(fieldName)) {
                    deserializedFileShareProperties.accessTierStatus = reader.getString();
                    continue;
                }
                if ("shareUsageBytes".equals(fieldName)) {
                    deserializedFileShareProperties.shareUsageBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("leaseStatus".equals(fieldName)) {
                    deserializedFileShareProperties.leaseStatus = LeaseStatus.fromString(reader.getString());
                    continue;
                }
                if ("leaseState".equals(fieldName)) {
                    deserializedFileShareProperties.leaseState = LeaseState.fromString(reader.getString());
                    continue;
                }
                if ("leaseDuration".equals(fieldName)) {
                    deserializedFileShareProperties.leaseDuration = LeaseDuration.fromString(reader.getString());
                    continue;
                }
                if ("signedIdentifiers".equals(fieldName)) {
                    List signedIdentifiers;
                    deserializedFileShareProperties.signedIdentifiers = signedIdentifiers = reader.readArray(reader1 -> SignedIdentifier.fromJson(reader1));
                    continue;
                }
                if ("snapshotTime".equals(fieldName)) {
                    deserializedFileShareProperties.snapshotTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("fileSharePaidBursting".equals(fieldName)) {
                    deserializedFileShareProperties.fileSharePaidBursting = FileSharePropertiesFileSharePaidBursting.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileShareProperties;
        });
    }
}

