// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for Schedule. */
public final class Schedule extends ExpandableStringEnum<Schedule> {
    /** Static value Daily for Schedule. */
    public static final Schedule DAILY = fromString("Daily");

    /** Static value Weekly for Schedule. */
    public static final Schedule WEEKLY = fromString("Weekly");

    /**
     * Creates or finds a Schedule from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding Schedule.
     */
    @JsonCreator
    public static Schedule fromString(String name) {
        return fromString(name, Schedule.class);
    }

    /** @return known Schedule values. */
    public static Collection<Schedule> values() {
        return values(Schedule.class);
    }
}
