// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for LeaseShareAction. */
public final class LeaseShareAction extends ExpandableStringEnum<LeaseShareAction> {
    /** Static value Acquire for LeaseShareAction. */
    public static final LeaseShareAction ACQUIRE = fromString("Acquire");

    /** Static value Renew for LeaseShareAction. */
    public static final LeaseShareAction RENEW = fromString("Renew");

    /** Static value Change for LeaseShareAction. */
    public static final LeaseShareAction CHANGE = fromString("Change");

    /** Static value Release for LeaseShareAction. */
    public static final LeaseShareAction RELEASE = fromString("Release");

    /** Static value Break for LeaseShareAction. */
    public static final LeaseShareAction BREAK = fromString("Break");

    /**
     * Creates or finds a LeaseShareAction from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding LeaseShareAction.
     */
    @JsonCreator
    public static LeaseShareAction fromString(String name) {
        return fromString(name, LeaseShareAction.class);
    }

    /** @return known LeaseShareAction values. */
    public static Collection<LeaseShareAction> values() {
        return values(LeaseShareAction.class);
    }
}
