// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.fluent.models.DeletedAccountInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The response from the List Deleted Accounts operation. */
@Immutable
public final class DeletedAccountListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DeletedAccountListResult.class);

    /*
     * Gets the list of deleted accounts and their properties.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<DeletedAccountInner> value;

    /*
     * Request URL that can be used to query next page of deleted accounts.
     * Returned when total number of requested deleted accounts exceed maximum
     * page size.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Get the value property: Gets the list of deleted accounts and their properties.
     *
     * @return the value value.
     */
    public List<DeletedAccountInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Request URL that can be used to query next page of deleted accounts. Returned when
     * total number of requested deleted accounts exceed maximum page size.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
