// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storage.fluent.models.TableInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in TablesClient. */
public interface TablesClient {
    /**
     * Creates a new table with the specified table name, under the specified account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the table, including Id, resource name, resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<TableInner>> createWithResponseAsync(String resourceGroupName, String accountName, String tableName);

    /**
     * Creates a new table with the specified table name, under the specified account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the table, including Id, resource name, resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TableInner> createAsync(String resourceGroupName, String accountName, String tableName);

    /**
     * Creates a new table with the specified table name, under the specified account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the table, including Id, resource name, resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TableInner create(String resourceGroupName, String accountName, String tableName);

    /**
     * Creates a new table with the specified table name, under the specified account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the table, including Id, resource name, resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<TableInner> createWithResponse(
        String resourceGroupName, String accountName, String tableName, Context context);

    /**
     * Creates a new table with the specified table name, under the specified account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the table, including Id, resource name, resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<TableInner>> updateWithResponseAsync(String resourceGroupName, String accountName, String tableName);

    /**
     * Creates a new table with the specified table name, under the specified account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the table, including Id, resource name, resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TableInner> updateAsync(String resourceGroupName, String accountName, String tableName);

    /**
     * Creates a new table with the specified table name, under the specified account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the table, including Id, resource name, resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TableInner update(String resourceGroupName, String accountName, String tableName);

    /**
     * Creates a new table with the specified table name, under the specified account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the table, including Id, resource name, resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<TableInner> updateWithResponse(
        String resourceGroupName, String accountName, String tableName, Context context);

    /**
     * Gets the table with the specified table name, under the specified account if it exists.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the table with the specified table name, under the specified account if it exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<TableInner>> getWithResponseAsync(String resourceGroupName, String accountName, String tableName);

    /**
     * Gets the table with the specified table name, under the specified account if it exists.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the table with the specified table name, under the specified account if it exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TableInner> getAsync(String resourceGroupName, String accountName, String tableName);

    /**
     * Gets the table with the specified table name, under the specified account if it exists.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the table with the specified table name, under the specified account if it exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TableInner get(String resourceGroupName, String accountName, String tableName);

    /**
     * Gets the table with the specified table name, under the specified account if it exists.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the table with the specified table name, under the specified account if it exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<TableInner> getWithResponse(
        String resourceGroupName, String accountName, String tableName, Context context);

    /**
     * Deletes the table with the specified table name, under the specified account if it exists.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName, String tableName);

    /**
     * Deletes the table with the specified table name, under the specified account if it exists.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String accountName, String tableName);

    /**
     * Deletes the table with the specified table name, under the specified account if it exists.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String accountName, String tableName);

    /**
     * Deletes the table with the specified table name, under the specified account if it exists.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The
     *     name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String accountName, String tableName, Context context);

    /**
     * Gets a list of all the tables under the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all the tables under the specified storage account.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<TableInner> listAsync(String resourceGroupName, String accountName);

    /**
     * Gets a list of all the tables under the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all the tables under the specified storage account.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<TableInner> list(String resourceGroupName, String accountName);

    /**
     * Gets a list of all the tables under the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all the tables under the specified storage account.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<TableInner> list(String resourceGroupName, String accountName, Context context);
}
