// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storage.fluent.models.SkuInformationInner;

/** An instance of this class provides access to all the operations defined in SkusClient. */
public interface SkusClient {
    /**
     * Lists the available SKUs supported by Microsoft.Storage for given subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Storage SKUs operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SkuInformationInner> listAsync();

    /**
     * Lists the available SKUs supported by Microsoft.Storage for given subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Storage SKUs operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SkuInformationInner> list();

    /**
     * Lists the available SKUs supported by Microsoft.Storage for given subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Storage SKUs operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SkuInformationInner> list(Context context);
}
