/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.Status;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class UpsertManagedServerOperationStepWithEstimatesAndDuration
implements JsonSerializable<UpsertManagedServerOperationStepWithEstimatesAndDuration> {
    private OffsetDateTime stepStartTime;
    private OffsetDateTime stepEndTime;
    private String timeElapsed;
    private Integer order;
    private String name;
    private Status status;

    public OffsetDateTime stepStartTime() {
        return this.stepStartTime;
    }

    public UpsertManagedServerOperationStepWithEstimatesAndDuration withStepStartTime(OffsetDateTime stepStartTime) {
        this.stepStartTime = stepStartTime;
        return this;
    }

    public OffsetDateTime stepEndTime() {
        return this.stepEndTime;
    }

    public UpsertManagedServerOperationStepWithEstimatesAndDuration withStepEndTime(OffsetDateTime stepEndTime) {
        this.stepEndTime = stepEndTime;
        return this;
    }

    public String timeElapsed() {
        return this.timeElapsed;
    }

    public UpsertManagedServerOperationStepWithEstimatesAndDuration withTimeElapsed(String timeElapsed) {
        this.timeElapsed = timeElapsed;
        return this;
    }

    public Integer order() {
        return this.order;
    }

    public UpsertManagedServerOperationStepWithEstimatesAndDuration withOrder(Integer order) {
        this.order = order;
        return this;
    }

    public String name() {
        return this.name;
    }

    public UpsertManagedServerOperationStepWithEstimatesAndDuration withName(String name) {
        this.name = name;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public UpsertManagedServerOperationStepWithEstimatesAndDuration withStatus(Status status) {
        this.status = status;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("stepStartTime", this.stepStartTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.stepStartTime));
        jsonWriter.writeStringField("stepEndTime", this.stepEndTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.stepEndTime));
        jsonWriter.writeStringField("timeElapsed", this.timeElapsed);
        jsonWriter.writeNumberField("order", (Number)this.order);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static UpsertManagedServerOperationStepWithEstimatesAndDuration fromJson(JsonReader jsonReader) throws IOException {
        return (UpsertManagedServerOperationStepWithEstimatesAndDuration)jsonReader.readObject(reader -> {
            UpsertManagedServerOperationStepWithEstimatesAndDuration deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration = new UpsertManagedServerOperationStepWithEstimatesAndDuration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("stepStartTime".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration.stepStartTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("stepEndTime".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration.stepEndTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("timeElapsed".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration.timeElapsed = reader.getString();
                    continue;
                }
                if ("order".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration.order = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration.name = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration.status = Status.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration;
        });
    }
}

