/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.WorkloadGroupProperties;
import java.io.IOException;

public final class WorkloadGroupInner
extends ProxyResource {
    private WorkloadGroupProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private WorkloadGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public Integer minResourcePercent() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().minResourcePercent());
    }

    public WorkloadGroupInner withMinResourcePercent(Integer minResourcePercent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadGroupProperties();
        }
        this.innerProperties().withMinResourcePercent(minResourcePercent);
        return this;
    }

    public Integer maxResourcePercent() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().maxResourcePercent());
    }

    public WorkloadGroupInner withMaxResourcePercent(Integer maxResourcePercent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadGroupProperties();
        }
        this.innerProperties().withMaxResourcePercent(maxResourcePercent);
        return this;
    }

    public Double minResourcePercentPerRequest() {
        return this.innerProperties() == null ? null : Double.valueOf(this.innerProperties().minResourcePercentPerRequest());
    }

    public WorkloadGroupInner withMinResourcePercentPerRequest(Double minResourcePercentPerRequest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadGroupProperties();
        }
        this.innerProperties().withMinResourcePercentPerRequest(minResourcePercentPerRequest);
        return this;
    }

    public Double maxResourcePercentPerRequest() {
        return this.innerProperties() == null ? null : this.innerProperties().maxResourcePercentPerRequest();
    }

    public WorkloadGroupInner withMaxResourcePercentPerRequest(Double maxResourcePercentPerRequest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadGroupProperties();
        }
        this.innerProperties().withMaxResourcePercentPerRequest(maxResourcePercentPerRequest);
        return this;
    }

    public String importance() {
        return this.innerProperties() == null ? null : this.innerProperties().importance();
    }

    public WorkloadGroupInner withImportance(String importance) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadGroupProperties();
        }
        this.innerProperties().withImportance(importance);
        return this;
    }

    public Integer queryExecutionTimeout() {
        return this.innerProperties() == null ? null : this.innerProperties().queryExecutionTimeout();
    }

    public WorkloadGroupInner withQueryExecutionTimeout(Integer queryExecutionTimeout) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadGroupProperties();
        }
        this.innerProperties().withQueryExecutionTimeout(queryExecutionTimeout);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WorkloadGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (WorkloadGroupInner)((Object)jsonReader.readObject(reader -> {
            WorkloadGroupInner deserializedWorkloadGroupInner = new WorkloadGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkloadGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkloadGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkloadGroupInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkloadGroupInner.innerProperties = WorkloadGroupProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkloadGroupInner;
        }));
    }
}

