/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CatalogCollationType;
import com.azure.resourcemanager.sql.models.ManagedDatabaseCreateMode;
import com.azure.resourcemanager.sql.models.ManagedDatabaseStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ManagedDatabaseProperties
implements JsonSerializable<ManagedDatabaseProperties> {
    private String collation;
    private ManagedDatabaseStatus status;
    private OffsetDateTime creationDate;
    private OffsetDateTime earliestRestorePoint;
    private OffsetDateTime restorePointInTime;
    private String defaultSecondaryLocation;
    private CatalogCollationType catalogCollation;
    private ManagedDatabaseCreateMode createMode;
    private String storageContainerUri;
    private String sourceDatabaseId;
    private String restorableDroppedDatabaseId;
    private String storageContainerSasToken;
    private String failoverGroupId;
    private String recoverableDatabaseId;
    private String longTermRetentionBackupResourceId;
    private Boolean autoCompleteRestore;
    private String lastBackupName;

    public String collation() {
        return this.collation;
    }

    public ManagedDatabaseProperties withCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public ManagedDatabaseStatus status() {
        return this.status;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public OffsetDateTime earliestRestorePoint() {
        return this.earliestRestorePoint;
    }

    public OffsetDateTime restorePointInTime() {
        return this.restorePointInTime;
    }

    public ManagedDatabaseProperties withRestorePointInTime(OffsetDateTime restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    public String defaultSecondaryLocation() {
        return this.defaultSecondaryLocation;
    }

    public CatalogCollationType catalogCollation() {
        return this.catalogCollation;
    }

    public ManagedDatabaseProperties withCatalogCollation(CatalogCollationType catalogCollation) {
        this.catalogCollation = catalogCollation;
        return this;
    }

    public ManagedDatabaseCreateMode createMode() {
        return this.createMode;
    }

    public ManagedDatabaseProperties withCreateMode(ManagedDatabaseCreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public String storageContainerUri() {
        return this.storageContainerUri;
    }

    public ManagedDatabaseProperties withStorageContainerUri(String storageContainerUri) {
        this.storageContainerUri = storageContainerUri;
        return this;
    }

    public String sourceDatabaseId() {
        return this.sourceDatabaseId;
    }

    public ManagedDatabaseProperties withSourceDatabaseId(String sourceDatabaseId) {
        this.sourceDatabaseId = sourceDatabaseId;
        return this;
    }

    public String restorableDroppedDatabaseId() {
        return this.restorableDroppedDatabaseId;
    }

    public ManagedDatabaseProperties withRestorableDroppedDatabaseId(String restorableDroppedDatabaseId) {
        this.restorableDroppedDatabaseId = restorableDroppedDatabaseId;
        return this;
    }

    public String storageContainerSasToken() {
        return this.storageContainerSasToken;
    }

    public ManagedDatabaseProperties withStorageContainerSasToken(String storageContainerSasToken) {
        this.storageContainerSasToken = storageContainerSasToken;
        return this;
    }

    public String failoverGroupId() {
        return this.failoverGroupId;
    }

    public String recoverableDatabaseId() {
        return this.recoverableDatabaseId;
    }

    public ManagedDatabaseProperties withRecoverableDatabaseId(String recoverableDatabaseId) {
        this.recoverableDatabaseId = recoverableDatabaseId;
        return this;
    }

    public String longTermRetentionBackupResourceId() {
        return this.longTermRetentionBackupResourceId;
    }

    public ManagedDatabaseProperties withLongTermRetentionBackupResourceId(String longTermRetentionBackupResourceId) {
        this.longTermRetentionBackupResourceId = longTermRetentionBackupResourceId;
        return this;
    }

    public Boolean autoCompleteRestore() {
        return this.autoCompleteRestore;
    }

    public ManagedDatabaseProperties withAutoCompleteRestore(Boolean autoCompleteRestore) {
        this.autoCompleteRestore = autoCompleteRestore;
        return this;
    }

    public String lastBackupName() {
        return this.lastBackupName;
    }

    public ManagedDatabaseProperties withLastBackupName(String lastBackupName) {
        this.lastBackupName = lastBackupName;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("collation", this.collation);
        jsonWriter.writeStringField("restorePointInTime", this.restorePointInTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.restorePointInTime));
        jsonWriter.writeStringField("catalogCollation", this.catalogCollation == null ? null : this.catalogCollation.toString());
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeStringField("storageContainerUri", this.storageContainerUri);
        jsonWriter.writeStringField("sourceDatabaseId", this.sourceDatabaseId);
        jsonWriter.writeStringField("restorableDroppedDatabaseId", this.restorableDroppedDatabaseId);
        jsonWriter.writeStringField("storageContainerSasToken", this.storageContainerSasToken);
        jsonWriter.writeStringField("recoverableDatabaseId", this.recoverableDatabaseId);
        jsonWriter.writeStringField("longTermRetentionBackupResourceId", this.longTermRetentionBackupResourceId);
        jsonWriter.writeBooleanField("autoCompleteRestore", this.autoCompleteRestore);
        jsonWriter.writeStringField("lastBackupName", this.lastBackupName);
        return jsonWriter.writeEndObject();
    }

    public static ManagedDatabaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedDatabaseProperties)jsonReader.readObject(reader -> {
            ManagedDatabaseProperties deserializedManagedDatabaseProperties = new ManagedDatabaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("collation".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.collation = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.status = ManagedDatabaseStatus.fromString(reader.getString());
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("earliestRestorePoint".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.earliestRestorePoint = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("restorePointInTime".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.restorePointInTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("defaultSecondaryLocation".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.defaultSecondaryLocation = reader.getString();
                    continue;
                }
                if ("catalogCollation".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.catalogCollation = CatalogCollationType.fromString(reader.getString());
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.createMode = ManagedDatabaseCreateMode.fromString(reader.getString());
                    continue;
                }
                if ("storageContainerUri".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.storageContainerUri = reader.getString();
                    continue;
                }
                if ("sourceDatabaseId".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.sourceDatabaseId = reader.getString();
                    continue;
                }
                if ("restorableDroppedDatabaseId".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.restorableDroppedDatabaseId = reader.getString();
                    continue;
                }
                if ("storageContainerSasToken".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.storageContainerSasToken = reader.getString();
                    continue;
                }
                if ("failoverGroupId".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.failoverGroupId = reader.getString();
                    continue;
                }
                if ("recoverableDatabaseId".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.recoverableDatabaseId = reader.getString();
                    continue;
                }
                if ("longTermRetentionBackupResourceId".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.longTermRetentionBackupResourceId = reader.getString();
                    continue;
                }
                if ("autoCompleteRestore".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.autoCompleteRestore = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastBackupName".equals(fieldName)) {
                    deserializedManagedDatabaseProperties.lastBackupName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedDatabaseProperties;
        });
    }
}

