/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.SyncAgentsClient;
import com.azure.resourcemanager.sql.fluent.models.SyncAgentInner;
import com.azure.resourcemanager.sql.fluent.models.SyncAgentKeyPropertiesInner;
import com.azure.resourcemanager.sql.fluent.models.SyncAgentLinkedDatabaseInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.SyncAgentLinkedDatabaseListResult;
import com.azure.resourcemanager.sql.models.SyncAgentListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SyncAgentsClientImpl
implements SyncAgentsClient {
    private final ClientLogger logger = new ClientLogger(SyncAgentsClientImpl.class);
    private final SyncAgentsService service;
    private final SqlManagementClientImpl client;

    SyncAgentsClientImpl(SqlManagementClientImpl client) {
        this.service = (SyncAgentsService)RestProxy.create(SyncAgentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<SyncAgentInner>> getWithResponseAsync(String resourceGroupName, String serverName, String syncAgentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (syncAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, syncAgentName, this.client.getSubscriptionId(), "2015-05-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SyncAgentInner>> getWithResponseAsync(String resourceGroupName, String serverName, String syncAgentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (syncAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, syncAgentName, this.client.getSubscriptionId(), "2015-05-01-preview", context);
    }

    @Override
    public Mono<SyncAgentInner> getAsync(String resourceGroupName, String serverName, String syncAgentName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, syncAgentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SyncAgentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SyncAgentInner get(String resourceGroupName, String serverName, String syncAgentName) {
        return (SyncAgentInner)((Object)this.getAsync(resourceGroupName, serverName, syncAgentName).block());
    }

    @Override
    public Response<SyncAgentInner> getWithResponse(String resourceGroupName, String serverName, String syncAgentName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, syncAgentName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (syncAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        SyncAgentInner parameters = new SyncAgentInner();
        parameters.withSyncDatabaseId(syncDatabaseId);
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, syncAgentName, this.client.getSubscriptionId(), "2015-05-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (syncAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        SyncAgentInner parameters = new SyncAgentInner();
        parameters.withSyncDatabaseId(syncDatabaseId);
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, syncAgentName, this.client.getSubscriptionId(), "2015-05-01-preview", parameters, context);
    }

    @Override
    public PollerFlux<PollResult<SyncAgentInner>, SyncAgentInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SyncAgentInner.class), (Type)((Object)SyncAgentInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<SyncAgentInner>, SyncAgentInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SyncAgentInner.class), (Type)((Object)SyncAgentInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<SyncAgentInner>, SyncAgentInner> beginCreateOrUpdate(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<SyncAgentInner>, SyncAgentInner> beginCreateOrUpdate(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId, context).getSyncPoller();
    }

    @Override
    public Mono<SyncAgentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<SyncAgentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<SyncAgentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String syncAgentName) {
        String syncDatabaseId = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public SyncAgentInner createOrUpdate(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId) {
        return (SyncAgentInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId).block());
    }

    @Override
    public SyncAgentInner createOrUpdate(String resourceGroupName, String serverName, String syncAgentName, String syncDatabaseId, Context context) {
        return (SyncAgentInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId, context).block());
    }

    @Override
    public SyncAgentInner createOrUpdate(String resourceGroupName, String serverName, String syncAgentName) {
        String syncDatabaseId = null;
        return (SyncAgentInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, syncAgentName, syncDatabaseId).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serverName, String syncAgentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (syncAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, syncAgentName, this.client.getSubscriptionId(), "2015-05-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serverName, String syncAgentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (syncAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, syncAgentName, this.client.getSubscriptionId(), "2015-05-01-preview", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serverName, String syncAgentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serverName, syncAgentName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serverName, String syncAgentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serverName, syncAgentName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serverName, String syncAgentName) {
        return this.beginDeleteAsync(resourceGroupName, serverName, syncAgentName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serverName, String syncAgentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serverName, syncAgentName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String serverName, String syncAgentName) {
        return this.beginDeleteAsync(resourceGroupName, serverName, syncAgentName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String serverName, String syncAgentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serverName, syncAgentName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String syncAgentName) {
        this.deleteAsync(resourceGroupName, serverName, syncAgentName).block();
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String syncAgentName, Context context) {
        this.deleteAsync(resourceGroupName, serverName, syncAgentName, context).block();
    }

    private Mono<PagedResponse<SyncAgentInner>> listByServerSinglePageAsync(String resourceGroupName, String serverName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        return FluxUtil.withContext(context -> this.service.listByServer(this.client.getEndpoint(), resourceGroupName, serverName, this.client.getSubscriptionId(), "2015-05-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncAgentListResult)res.getValue()).value(), ((SyncAgentListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SyncAgentInner>> listByServerSinglePageAsync(String resourceGroupName, String serverName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listByServer(this.client.getEndpoint(), resourceGroupName, serverName, this.client.getSubscriptionId(), "2015-05-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncAgentListResult)res.getValue()).value(), ((SyncAgentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<SyncAgentInner> listByServerAsync(String resourceGroupName, String serverName) {
        return new PagedFlux(() -> this.listByServerSinglePageAsync(resourceGroupName, serverName), nextLink -> this.listByServerNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<SyncAgentInner> listByServerAsync(String resourceGroupName, String serverName, Context context) {
        return new PagedFlux(() -> this.listByServerSinglePageAsync(resourceGroupName, serverName, context), nextLink -> this.listByServerNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<SyncAgentInner> listByServer(String resourceGroupName, String serverName) {
        return new PagedIterable(this.listByServerAsync(resourceGroupName, serverName));
    }

    @Override
    public PagedIterable<SyncAgentInner> listByServer(String resourceGroupName, String serverName, Context context) {
        return new PagedIterable(this.listByServerAsync(resourceGroupName, serverName, context));
    }

    @Override
    public Mono<Response<SyncAgentKeyPropertiesInner>> generateKeyWithResponseAsync(String resourceGroupName, String serverName, String syncAgentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (syncAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        return FluxUtil.withContext(context -> this.service.generateKey(this.client.getEndpoint(), resourceGroupName, serverName, syncAgentName, this.client.getSubscriptionId(), "2015-05-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SyncAgentKeyPropertiesInner>> generateKeyWithResponseAsync(String resourceGroupName, String serverName, String syncAgentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (syncAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.generateKey(this.client.getEndpoint(), resourceGroupName, serverName, syncAgentName, this.client.getSubscriptionId(), "2015-05-01-preview", context);
    }

    @Override
    public Mono<SyncAgentKeyPropertiesInner> generateKeyAsync(String resourceGroupName, String serverName, String syncAgentName) {
        return this.generateKeyWithResponseAsync(resourceGroupName, serverName, syncAgentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SyncAgentKeyPropertiesInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public SyncAgentKeyPropertiesInner generateKey(String resourceGroupName, String serverName, String syncAgentName) {
        return (SyncAgentKeyPropertiesInner)this.generateKeyAsync(resourceGroupName, serverName, syncAgentName).block();
    }

    @Override
    public Response<SyncAgentKeyPropertiesInner> generateKeyWithResponse(String resourceGroupName, String serverName, String syncAgentName, Context context) {
        return (Response)this.generateKeyWithResponseAsync(resourceGroupName, serverName, syncAgentName, context).block();
    }

    private Mono<PagedResponse<SyncAgentLinkedDatabaseInner>> listLinkedDatabasesSinglePageAsync(String resourceGroupName, String serverName, String syncAgentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (syncAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        return FluxUtil.withContext(context -> this.service.listLinkedDatabases(this.client.getEndpoint(), resourceGroupName, serverName, syncAgentName, this.client.getSubscriptionId(), "2015-05-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncAgentLinkedDatabaseListResult)res.getValue()).value(), ((SyncAgentLinkedDatabaseListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SyncAgentLinkedDatabaseInner>> listLinkedDatabasesSinglePageAsync(String resourceGroupName, String serverName, String syncAgentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (syncAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listLinkedDatabases(this.client.getEndpoint(), resourceGroupName, serverName, syncAgentName, this.client.getSubscriptionId(), "2015-05-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncAgentLinkedDatabaseListResult)res.getValue()).value(), ((SyncAgentLinkedDatabaseListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<SyncAgentLinkedDatabaseInner> listLinkedDatabasesAsync(String resourceGroupName, String serverName, String syncAgentName) {
        return new PagedFlux(() -> this.listLinkedDatabasesSinglePageAsync(resourceGroupName, serverName, syncAgentName), nextLink -> this.listLinkedDatabasesNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<SyncAgentLinkedDatabaseInner> listLinkedDatabasesAsync(String resourceGroupName, String serverName, String syncAgentName, Context context) {
        return new PagedFlux(() -> this.listLinkedDatabasesSinglePageAsync(resourceGroupName, serverName, syncAgentName, context), nextLink -> this.listLinkedDatabasesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<SyncAgentLinkedDatabaseInner> listLinkedDatabases(String resourceGroupName, String serverName, String syncAgentName) {
        return new PagedIterable(this.listLinkedDatabasesAsync(resourceGroupName, serverName, syncAgentName));
    }

    @Override
    public PagedIterable<SyncAgentLinkedDatabaseInner> listLinkedDatabases(String resourceGroupName, String serverName, String syncAgentName, Context context) {
        return new PagedIterable(this.listLinkedDatabasesAsync(resourceGroupName, serverName, syncAgentName, context));
    }

    private Mono<PagedResponse<SyncAgentInner>> listByServerNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByServerNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncAgentListResult)res.getValue()).value(), ((SyncAgentListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SyncAgentInner>> listByServerNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByServerNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncAgentListResult)res.getValue()).value(), ((SyncAgentListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<SyncAgentLinkedDatabaseInner>> listLinkedDatabasesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listLinkedDatabasesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncAgentLinkedDatabaseListResult)res.getValue()).value(), ((SyncAgentLinkedDatabaseListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SyncAgentLinkedDatabaseInner>> listLinkedDatabasesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listLinkedDatabasesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncAgentLinkedDatabaseListResult)res.getValue()).value(), ((SyncAgentLinkedDatabaseListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientS")
    private static interface SyncAgentsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SyncAgentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="syncAgentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="syncAgentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") SyncAgentInner var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="syncAgentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SyncAgentListResult>> listByServer(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}/generateKey")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SyncAgentKeyPropertiesInner>> generateKey(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="syncAgentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}/linkedDatabases")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SyncAgentLinkedDatabaseListResult>> listLinkedDatabases(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="syncAgentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SyncAgentListResult>> listByServerNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SyncAgentLinkedDatabaseListResult>> listLinkedDatabasesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

