/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.DatabaseVulnerabilityAssessmentScansClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseVulnerabilityAssessmentScansExportInner;
import com.azure.resourcemanager.sql.fluent.models.VulnerabilityAssessmentScanRecordInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanRecordListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DatabaseVulnerabilityAssessmentScansClientImpl
implements DatabaseVulnerabilityAssessmentScansClient {
    private final ClientLogger logger = new ClientLogger(DatabaseVulnerabilityAssessmentScansClientImpl.class);
    private final DatabaseVulnerabilityAssessmentScansService service;
    private final SqlManagementClientImpl client;

    DatabaseVulnerabilityAssessmentScansClientImpl(SqlManagementClientImpl client) {
        this.service = (DatabaseVulnerabilityAssessmentScansService)RestProxy.create(DatabaseVulnerabilityAssessmentScansService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<VulnerabilityAssessmentScanRecordInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), "2017-10-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).value(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<VulnerabilityAssessmentScanRecordInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), "2017-10-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).value(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<VulnerabilityAssessmentScanRecordInner> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<VulnerabilityAssessmentScanRecordInner> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, context), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<VulnerabilityAssessmentScanRecordInner> listByDatabase(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return new PagedIterable(this.listByDatabaseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName));
    }

    @Override
    public PagedIterable<VulnerabilityAssessmentScanRecordInner> listByDatabase(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        return new PagedIterable(this.listByDatabaseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, context));
    }

    @Override
    public Mono<Response<VulnerabilityAssessmentScanRecordInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), "2017-10-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<VulnerabilityAssessmentScanRecordInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), "2017-10-01-preview", context);
    }

    @Override
    public Mono<VulnerabilityAssessmentScanRecordInner> getAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return this.getWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((VulnerabilityAssessmentScanRecordInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public VulnerabilityAssessmentScanRecordInner get(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return (VulnerabilityAssessmentScanRecordInner)((Object)this.getAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId).block());
    }

    @Override
    public Response<VulnerabilityAssessmentScanRecordInner> getWithResponse(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> initiateScanWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.initiateScan(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), "2017-10-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> initiateScanWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.initiateScan(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), "2017-10-01-preview", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginInitiateScanAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.initiateScanWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginInitiateScanAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.initiateScanWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginInitiateScan(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return this.beginInitiateScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginInitiateScan(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return this.beginInitiateScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, context).getSyncPoller();
    }

    @Override
    public Mono<Void> initiateScanAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return this.beginInitiateScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> initiateScanAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return this.beginInitiateScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void initiateScan(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        this.initiateScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId).block();
    }

    @Override
    public void initiateScan(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        this.initiateScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, context).block();
    }

    @Override
    public Mono<Response<DatabaseVulnerabilityAssessmentScansExportInner>> exportWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.export(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), "2017-10-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<DatabaseVulnerabilityAssessmentScansExportInner>> exportWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.export(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), "2017-10-01-preview", context);
    }

    @Override
    public Mono<DatabaseVulnerabilityAssessmentScansExportInner> exportAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return this.exportWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DatabaseVulnerabilityAssessmentScansExportInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public DatabaseVulnerabilityAssessmentScansExportInner export(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return (DatabaseVulnerabilityAssessmentScansExportInner)((Object)this.exportAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId).block());
    }

    @Override
    public Response<DatabaseVulnerabilityAssessmentScansExportInner> exportWithResponse(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return (Response)this.exportWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, context).block();
    }

    private Mono<PagedResponse<VulnerabilityAssessmentScanRecordInner>> listByDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByDatabaseNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).value(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<VulnerabilityAssessmentScanRecordInner>> listByDatabaseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByDatabaseNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).value(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientD")
    private static interface DatabaseVulnerabilityAssessmentScansService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VulnerabilityAssessmentScanRecordListResult>> listByDatabase(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VulnerabilityAssessmentScanRecordInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="scanId") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> initiateScan(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="scanId") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/export")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseVulnerabilityAssessmentScansExportInner>> export(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="scanId") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VulnerabilityAssessmentScanRecordListResult>> listByDatabaseNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

