/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.ElasticPoolLicenseType;
import com.azure.resourcemanager.sql.models.ElasticPoolPerDatabaseSettings;
import com.azure.resourcemanager.sql.models.ElasticPoolState;
import com.azure.resourcemanager.sql.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

@JsonFlatten
public class ElasticPoolInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ElasticPoolInner.class);
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="kind", access=JsonProperty.Access.WRITE_ONLY)
    private String kind;
    @JsonProperty(value="properties.state", access=JsonProperty.Access.WRITE_ONLY)
    private ElasticPoolState state;
    @JsonProperty(value="properties.creationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;
    @JsonProperty(value="properties.maxSizeBytes")
    private Long maxSizeBytes;
    @JsonProperty(value="properties.perDatabaseSettings")
    private ElasticPoolPerDatabaseSettings perDatabaseSettings;
    @JsonProperty(value="properties.zoneRedundant")
    private Boolean zoneRedundant;
    @JsonProperty(value="properties.licenseType")
    private ElasticPoolLicenseType licenseType;

    public Sku sku() {
        return this.sku;
    }

    public ElasticPoolInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public ElasticPoolState state() {
        return this.state;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public ElasticPoolInner withMaxSizeBytes(Long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public ElasticPoolPerDatabaseSettings perDatabaseSettings() {
        return this.perDatabaseSettings;
    }

    public ElasticPoolInner withPerDatabaseSettings(ElasticPoolPerDatabaseSettings perDatabaseSettings) {
        this.perDatabaseSettings = perDatabaseSettings;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public ElasticPoolInner withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public ElasticPoolLicenseType licenseType() {
        return this.licenseType;
    }

    public ElasticPoolInner withLicenseType(ElasticPoolLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.perDatabaseSettings() != null) {
            this.perDatabaseSettings().validate();
        }
    }
}

