/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class Action
implements JsonSerializable<Action> {
    private String sqlExpression;
    private Integer compatibilityLevel;
    private Boolean requiresPreprocessing;

    public String sqlExpression() {
        return this.sqlExpression;
    }

    public Action withSqlExpression(String sqlExpression) {
        this.sqlExpression = sqlExpression;
        return this;
    }

    public Integer compatibilityLevel() {
        return this.compatibilityLevel;
    }

    public Action withCompatibilityLevel(Integer compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
        return this;
    }

    public Boolean requiresPreprocessing() {
        return this.requiresPreprocessing;
    }

    public Action withRequiresPreprocessing(Boolean requiresPreprocessing) {
        this.requiresPreprocessing = requiresPreprocessing;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sqlExpression", this.sqlExpression);
        jsonWriter.writeNumberField("compatibilityLevel", (Number)this.compatibilityLevel);
        jsonWriter.writeBooleanField("requiresPreprocessing", this.requiresPreprocessing);
        return jsonWriter.writeEndObject();
    }

    public static Action fromJson(JsonReader jsonReader) throws IOException {
        return (Action)jsonReader.readObject(reader -> {
            Action deserializedAction = new Action();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sqlExpression".equals(fieldName)) {
                    deserializedAction.sqlExpression = reader.getString();
                    continue;
                }
                if ("compatibilityLevel".equals(fieldName)) {
                    deserializedAction.compatibilityLevel = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("requiresPreprocessing".equals(fieldName)) {
                    deserializedAction.requiresPreprocessing = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAction;
        });
    }
}

