/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.search.models.DataPlaneAadOrApiKeyAuthOption;
import java.io.IOException;

public final class DataPlaneAuthOptions
implements JsonSerializable<DataPlaneAuthOptions> {
    private Object apiKeyOnly;
    private DataPlaneAadOrApiKeyAuthOption aadOrApiKey;

    public Object apiKeyOnly() {
        return this.apiKeyOnly;
    }

    public DataPlaneAuthOptions withApiKeyOnly(Object apiKeyOnly) {
        this.apiKeyOnly = apiKeyOnly;
        return this;
    }

    public DataPlaneAadOrApiKeyAuthOption aadOrApiKey() {
        return this.aadOrApiKey;
    }

    public DataPlaneAuthOptions withAadOrApiKey(DataPlaneAadOrApiKeyAuthOption aadOrApiKey) {
        this.aadOrApiKey = aadOrApiKey;
        return this;
    }

    public void validate() {
        if (this.aadOrApiKey() != null) {
            this.aadOrApiKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.apiKeyOnly != null) {
            jsonWriter.writeUntypedField("apiKeyOnly", this.apiKeyOnly);
        }
        jsonWriter.writeJsonField("aadOrApiKey", (JsonSerializable)this.aadOrApiKey);
        return jsonWriter.writeEndObject();
    }

    public static DataPlaneAuthOptions fromJson(JsonReader jsonReader) throws IOException {
        return (DataPlaneAuthOptions)jsonReader.readObject(reader -> {
            DataPlaneAuthOptions deserializedDataPlaneAuthOptions = new DataPlaneAuthOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("apiKeyOnly".equals(fieldName)) {
                    deserializedDataPlaneAuthOptions.apiKeyOnly = reader.readUntyped();
                    continue;
                }
                if ("aadOrApiKey".equals(fieldName)) {
                    deserializedDataPlaneAuthOptions.aadOrApiKey = DataPlaneAadOrApiKeyAuthOption.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataPlaneAuthOptions;
        });
    }
}

