/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class NetworkSecurityPerimeter
implements JsonSerializable<NetworkSecurityPerimeter> {
    private String id;
    private UUID perimeterGuid;
    private String location;

    public String id() {
        return this.id;
    }

    public NetworkSecurityPerimeter withId(String id) {
        this.id = id;
        return this;
    }

    public UUID perimeterGuid() {
        return this.perimeterGuid;
    }

    public NetworkSecurityPerimeter withPerimeterGuid(UUID perimeterGuid) {
        this.perimeterGuid = perimeterGuid;
        return this;
    }

    public String location() {
        return this.location;
    }

    public NetworkSecurityPerimeter withLocation(String location) {
        this.location = location;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("perimeterGuid", Objects.toString(this.perimeterGuid, null));
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityPerimeter fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityPerimeter)jsonReader.readObject(reader -> {
            NetworkSecurityPerimeter deserializedNetworkSecurityPerimeter = new NetworkSecurityPerimeter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeter.id = reader.getString();
                    continue;
                }
                if ("perimeterGuid".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeter.perimeterGuid = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeter.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityPerimeter;
        });
    }
}

