/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ChangeType;
import com.azure.resourcemanager.resources.models.DeploymentExtensionDefinition;
import com.azure.resourcemanager.resources.models.WhatIfPropertyChange;
import java.io.IOException;
import java.util.List;

public final class WhatIfChange
implements JsonSerializable<WhatIfChange> {
    private String resourceId;
    private String deploymentId;
    private String symbolicName;
    private Object identifiers;
    private DeploymentExtensionDefinition extension;
    private ChangeType changeType;
    private String unsupportedReason;
    private Object before;
    private Object after;
    private List<WhatIfPropertyChange> delta;
    private static final ClientLogger LOGGER = new ClientLogger(WhatIfChange.class);

    public String resourceId() {
        return this.resourceId;
    }

    public WhatIfChange withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public WhatIfChange withDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    public String symbolicName() {
        return this.symbolicName;
    }

    public WhatIfChange withSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
        return this;
    }

    public Object identifiers() {
        return this.identifiers;
    }

    public WhatIfChange withIdentifiers(Object identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    public DeploymentExtensionDefinition extension() {
        return this.extension;
    }

    public WhatIfChange withExtension(DeploymentExtensionDefinition extension) {
        this.extension = extension;
        return this;
    }

    public ChangeType changeType() {
        return this.changeType;
    }

    public WhatIfChange withChangeType(ChangeType changeType) {
        this.changeType = changeType;
        return this;
    }

    public String unsupportedReason() {
        return this.unsupportedReason;
    }

    public WhatIfChange withUnsupportedReason(String unsupportedReason) {
        this.unsupportedReason = unsupportedReason;
        return this;
    }

    public Object before() {
        return this.before;
    }

    public WhatIfChange withBefore(Object before) {
        this.before = before;
        return this;
    }

    public Object after() {
        return this.after;
    }

    public WhatIfChange withAfter(Object after) {
        this.after = after;
        return this;
    }

    public List<WhatIfPropertyChange> delta() {
        return this.delta;
    }

    public WhatIfChange withDelta(List<WhatIfPropertyChange> delta) {
        this.delta = delta;
        return this;
    }

    public void validate() {
        if (this.extension() != null) {
            this.extension().validate();
        }
        if (this.changeType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property changeType in model WhatIfChange"));
        }
        if (this.delta() != null) {
            this.delta().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("changeType", this.changeType == null ? null : this.changeType.toString());
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("deploymentId", this.deploymentId);
        jsonWriter.writeStringField("symbolicName", this.symbolicName);
        if (this.identifiers != null) {
            jsonWriter.writeUntypedField("identifiers", this.identifiers);
        }
        jsonWriter.writeJsonField("extension", (JsonSerializable)this.extension);
        jsonWriter.writeStringField("unsupportedReason", this.unsupportedReason);
        if (this.before != null) {
            jsonWriter.writeUntypedField("before", this.before);
        }
        if (this.after != null) {
            jsonWriter.writeUntypedField("after", this.after);
        }
        jsonWriter.writeArrayField("delta", this.delta, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static WhatIfChange fromJson(JsonReader jsonReader) throws IOException {
        return (WhatIfChange)jsonReader.readObject(reader -> {
            WhatIfChange deserializedWhatIfChange = new WhatIfChange();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("changeType".equals(fieldName)) {
                    deserializedWhatIfChange.changeType = ChangeType.fromString(reader.getString());
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedWhatIfChange.resourceId = reader.getString();
                    continue;
                }
                if ("deploymentId".equals(fieldName)) {
                    deserializedWhatIfChange.deploymentId = reader.getString();
                    continue;
                }
                if ("symbolicName".equals(fieldName)) {
                    deserializedWhatIfChange.symbolicName = reader.getString();
                    continue;
                }
                if ("identifiers".equals(fieldName)) {
                    deserializedWhatIfChange.identifiers = reader.readUntyped();
                    continue;
                }
                if ("extension".equals(fieldName)) {
                    deserializedWhatIfChange.extension = DeploymentExtensionDefinition.fromJson(reader);
                    continue;
                }
                if ("unsupportedReason".equals(fieldName)) {
                    deserializedWhatIfChange.unsupportedReason = reader.getString();
                    continue;
                }
                if ("before".equals(fieldName)) {
                    deserializedWhatIfChange.before = reader.readUntyped();
                    continue;
                }
                if ("after".equals(fieldName)) {
                    deserializedWhatIfChange.after = reader.readUntyped();
                    continue;
                }
                if ("delta".equals(fieldName)) {
                    List delta;
                    deserializedWhatIfChange.delta = delta = reader.readArray(reader1 -> WhatIfPropertyChange.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWhatIfChange;
        });
    }
}

