/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.AliasPatternType;
import java.io.IOException;

public final class AliasPattern
implements JsonSerializable<AliasPattern> {
    private String phrase;
    private String variable;
    private AliasPatternType type;

    public String phrase() {
        return this.phrase;
    }

    public AliasPattern withPhrase(String phrase) {
        this.phrase = phrase;
        return this;
    }

    public String variable() {
        return this.variable;
    }

    public AliasPattern withVariable(String variable) {
        this.variable = variable;
        return this;
    }

    public AliasPatternType type() {
        return this.type;
    }

    public AliasPattern withType(AliasPatternType type) {
        this.type = type;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("phrase", this.phrase);
        jsonWriter.writeStringField("variable", this.variable);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static AliasPattern fromJson(JsonReader jsonReader) throws IOException {
        return (AliasPattern)jsonReader.readObject(reader -> {
            AliasPattern deserializedAliasPattern = new AliasPattern();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("phrase".equals(fieldName)) {
                    deserializedAliasPattern.phrase = reader.getString();
                    continue;
                }
                if ("variable".equals(fieldName)) {
                    deserializedAliasPattern.variable = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAliasPattern.type = AliasPatternType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAliasPattern;
        });
    }
}

