/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DeploymentStacksDeleteDetachEnum;
import java.io.IOException;

public final class ActionOnUnmanage
implements JsonSerializable<ActionOnUnmanage> {
    private DeploymentStacksDeleteDetachEnum resources;
    private DeploymentStacksDeleteDetachEnum resourceGroups;
    private DeploymentStacksDeleteDetachEnum managementGroups;
    private static final ClientLogger LOGGER = new ClientLogger(ActionOnUnmanage.class);

    public DeploymentStacksDeleteDetachEnum resources() {
        return this.resources;
    }

    public ActionOnUnmanage withResources(DeploymentStacksDeleteDetachEnum resources) {
        this.resources = resources;
        return this;
    }

    public DeploymentStacksDeleteDetachEnum resourceGroups() {
        return this.resourceGroups;
    }

    public ActionOnUnmanage withResourceGroups(DeploymentStacksDeleteDetachEnum resourceGroups) {
        this.resourceGroups = resourceGroups;
        return this;
    }

    public DeploymentStacksDeleteDetachEnum managementGroups() {
        return this.managementGroups;
    }

    public ActionOnUnmanage withManagementGroups(DeploymentStacksDeleteDetachEnum managementGroups) {
        this.managementGroups = managementGroups;
        return this;
    }

    public void validate() {
        if (this.resources() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resources in model ActionOnUnmanage"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resources", this.resources == null ? null : this.resources.toString());
        jsonWriter.writeStringField("resourceGroups", this.resourceGroups == null ? null : this.resourceGroups.toString());
        jsonWriter.writeStringField("managementGroups", this.managementGroups == null ? null : this.managementGroups.toString());
        return jsonWriter.writeEndObject();
    }

    public static ActionOnUnmanage fromJson(JsonReader jsonReader) throws IOException {
        return (ActionOnUnmanage)jsonReader.readObject(reader -> {
            ActionOnUnmanage deserializedActionOnUnmanage = new ActionOnUnmanage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resources".equals(fieldName)) {
                    deserializedActionOnUnmanage.resources = DeploymentStacksDeleteDetachEnum.fromString(reader.getString());
                    continue;
                }
                if ("resourceGroups".equals(fieldName)) {
                    deserializedActionOnUnmanage.resourceGroups = DeploymentStacksDeleteDetachEnum.fromString(reader.getString());
                    continue;
                }
                if ("managementGroups".equals(fieldName)) {
                    deserializedActionOnUnmanage.managementGroups = DeploymentStacksDeleteDetachEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActionOnUnmanage;
        });
    }
}

