/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CreatedByType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SecurityPerimeterSystemData
implements JsonSerializable<SecurityPerimeterSystemData> {
    private String createdBy;
    private CreatedByType createdByType;
    private OffsetDateTime createdAt;
    private String lastModifiedBy;
    private CreatedByType lastModifiedByType;
    private OffsetDateTime lastModifiedAt;

    public String createdBy() {
        return this.createdBy;
    }

    public SecurityPerimeterSystemData withCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public CreatedByType createdByType() {
        return this.createdByType;
    }

    public SecurityPerimeterSystemData withCreatedByType(CreatedByType createdByType) {
        this.createdByType = createdByType;
        return this;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public SecurityPerimeterSystemData withCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public SecurityPerimeterSystemData withLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    public CreatedByType lastModifiedByType() {
        return this.lastModifiedByType;
    }

    public SecurityPerimeterSystemData withLastModifiedByType(CreatedByType lastModifiedByType) {
        this.lastModifiedByType = lastModifiedByType;
        return this;
    }

    public OffsetDateTime lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public SecurityPerimeterSystemData withLastModifiedAt(OffsetDateTime lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdBy", this.createdBy);
        jsonWriter.writeStringField("createdByType", this.createdByType == null ? null : this.createdByType.toString());
        jsonWriter.writeStringField("createdAt", this.createdAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdAt));
        jsonWriter.writeStringField("lastModifiedBy", this.lastModifiedBy);
        jsonWriter.writeStringField("lastModifiedByType", this.lastModifiedByType == null ? null : this.lastModifiedByType.toString());
        jsonWriter.writeStringField("lastModifiedAt", this.lastModifiedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedAt));
        return jsonWriter.writeEndObject();
    }

    public static SecurityPerimeterSystemData fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityPerimeterSystemData)jsonReader.readObject(reader -> {
            SecurityPerimeterSystemData deserializedSecurityPerimeterSystemData = new SecurityPerimeterSystemData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdBy".equals(fieldName)) {
                    deserializedSecurityPerimeterSystemData.createdBy = reader.getString();
                    continue;
                }
                if ("createdByType".equals(fieldName)) {
                    deserializedSecurityPerimeterSystemData.createdByType = CreatedByType.fromString(reader.getString());
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedSecurityPerimeterSystemData.createdAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedSecurityPerimeterSystemData.lastModifiedBy = reader.getString();
                    continue;
                }
                if ("lastModifiedByType".equals(fieldName)) {
                    deserializedSecurityPerimeterSystemData.lastModifiedByType = CreatedByType.fromString(reader.getString());
                    continue;
                }
                if ("lastModifiedAt".equals(fieldName)) {
                    deserializedSecurityPerimeterSystemData.lastModifiedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityPerimeterSystemData;
        });
    }
}

