/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FirewallPolicyLogAnalyticsWorkspace;
import java.io.IOException;
import java.util.List;

public final class FirewallPolicyLogAnalyticsResources
implements JsonSerializable<FirewallPolicyLogAnalyticsResources> {
    private List<FirewallPolicyLogAnalyticsWorkspace> workspaces;
    private SubResource defaultWorkspaceId;

    public List<FirewallPolicyLogAnalyticsWorkspace> workspaces() {
        return this.workspaces;
    }

    public FirewallPolicyLogAnalyticsResources withWorkspaces(List<FirewallPolicyLogAnalyticsWorkspace> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    public SubResource defaultWorkspaceId() {
        return this.defaultWorkspaceId;
    }

    public FirewallPolicyLogAnalyticsResources withDefaultWorkspaceId(SubResource defaultWorkspaceId) {
        this.defaultWorkspaceId = defaultWorkspaceId;
        return this;
    }

    public void validate() {
        if (this.workspaces() != null) {
            this.workspaces().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("workspaces", this.workspaces, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("defaultWorkspaceId", (JsonSerializable)this.defaultWorkspaceId);
        return jsonWriter.writeEndObject();
    }

    public static FirewallPolicyLogAnalyticsResources fromJson(JsonReader jsonReader) throws IOException {
        return (FirewallPolicyLogAnalyticsResources)jsonReader.readObject(reader -> {
            FirewallPolicyLogAnalyticsResources deserializedFirewallPolicyLogAnalyticsResources = new FirewallPolicyLogAnalyticsResources();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("workspaces".equals(fieldName)) {
                    List workspaces;
                    deserializedFirewallPolicyLogAnalyticsResources.workspaces = workspaces = reader.readArray(reader1 -> FirewallPolicyLogAnalyticsWorkspace.fromJson(reader1));
                    continue;
                }
                if ("defaultWorkspaceId".equals(fieldName)) {
                    deserializedFirewallPolicyLogAnalyticsResources.defaultWorkspaceId = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirewallPolicyLogAnalyticsResources;
        });
    }
}

