/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.FrontendIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceTapConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkTapPropertiesFormatInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualNetworkTapInner
extends Resource {
    private VirtualNetworkTapPropertiesFormatInner innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    private VirtualNetworkTapPropertiesFormatInner innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public VirtualNetworkTapInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public VirtualNetworkTapInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualNetworkTapInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<NetworkInterfaceTapConfigurationInner> networkInterfaceTapConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().networkInterfaceTapConfigurations();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public NetworkInterfaceIpConfigurationInner destinationNetworkInterfaceIpConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationNetworkInterfaceIpConfiguration();
    }

    public VirtualNetworkTapInner withDestinationNetworkInterfaceIpConfiguration(NetworkInterfaceIpConfigurationInner destinationNetworkInterfaceIpConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkTapPropertiesFormatInner();
        }
        this.innerProperties().withDestinationNetworkInterfaceIpConfiguration(destinationNetworkInterfaceIpConfiguration);
        return this;
    }

    public FrontendIpConfigurationInner destinationLoadBalancerFrontEndIpConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationLoadBalancerFrontEndIpConfiguration();
    }

    public VirtualNetworkTapInner withDestinationLoadBalancerFrontEndIpConfiguration(FrontendIpConfigurationInner destinationLoadBalancerFrontEndIpConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkTapPropertiesFormatInner();
        }
        this.innerProperties().withDestinationLoadBalancerFrontEndIpConfiguration(destinationLoadBalancerFrontEndIpConfiguration);
        return this;
    }

    public Integer destinationPort() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationPort();
    }

    public VirtualNetworkTapInner withDestinationPort(Integer destinationPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkTapPropertiesFormatInner();
        }
        this.innerProperties().withDestinationPort(destinationPort);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkTapInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkTapInner)((Object)jsonReader.readObject(reader -> {
            VirtualNetworkTapInner deserializedVirtualNetworkTapInner = new VirtualNetworkTapInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVirtualNetworkTapInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualNetworkTapInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVirtualNetworkTapInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualNetworkTapInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualNetworkTapInner.innerProperties = VirtualNetworkTapPropertiesFormatInner.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVirtualNetworkTapInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVirtualNetworkTapInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkTapInner;
        }));
    }
}

