/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NspLinkProvisioningState;
import com.azure.resourcemanager.network.models.NspLinkStatus;
import java.io.IOException;
import java.util.List;

public final class NspLinkReferenceProperties
implements JsonSerializable<NspLinkReferenceProperties> {
    private NspLinkProvisioningState provisioningState;
    private String remotePerimeterResourceId;
    private String remotePerimeterGuid;
    private String remotePerimeterLocation;
    private List<String> localInboundProfiles;
    private List<String> localOutboundProfiles;
    private List<String> remoteInboundProfiles;
    private List<String> remoteOutboundProfiles;
    private String description;
    private NspLinkStatus status;

    public NspLinkProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String remotePerimeterResourceId() {
        return this.remotePerimeterResourceId;
    }

    public String remotePerimeterGuid() {
        return this.remotePerimeterGuid;
    }

    public String remotePerimeterLocation() {
        return this.remotePerimeterLocation;
    }

    public List<String> localInboundProfiles() {
        return this.localInboundProfiles;
    }

    public NspLinkReferenceProperties withLocalInboundProfiles(List<String> localInboundProfiles) {
        this.localInboundProfiles = localInboundProfiles;
        return this;
    }

    public List<String> localOutboundProfiles() {
        return this.localOutboundProfiles;
    }

    public List<String> remoteInboundProfiles() {
        return this.remoteInboundProfiles;
    }

    public List<String> remoteOutboundProfiles() {
        return this.remoteOutboundProfiles;
    }

    public String description() {
        return this.description;
    }

    public NspLinkStatus status() {
        return this.status;
    }

    public NspLinkReferenceProperties withStatus(NspLinkStatus status) {
        this.status = status;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("localInboundProfiles", this.localInboundProfiles, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static NspLinkReferenceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NspLinkReferenceProperties)jsonReader.readObject(reader -> {
            NspLinkReferenceProperties deserializedNspLinkReferenceProperties = new NspLinkReferenceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedNspLinkReferenceProperties.provisioningState = NspLinkProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("remotePerimeterResourceId".equals(fieldName)) {
                    deserializedNspLinkReferenceProperties.remotePerimeterResourceId = reader.getString();
                    continue;
                }
                if ("remotePerimeterGuid".equals(fieldName)) {
                    deserializedNspLinkReferenceProperties.remotePerimeterGuid = reader.getString();
                    continue;
                }
                if ("remotePerimeterLocation".equals(fieldName)) {
                    deserializedNspLinkReferenceProperties.remotePerimeterLocation = reader.getString();
                    continue;
                }
                if ("localInboundProfiles".equals(fieldName)) {
                    List localInboundProfiles;
                    deserializedNspLinkReferenceProperties.localInboundProfiles = localInboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("localOutboundProfiles".equals(fieldName)) {
                    List localOutboundProfiles;
                    deserializedNspLinkReferenceProperties.localOutboundProfiles = localOutboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("remoteInboundProfiles".equals(fieldName)) {
                    List remoteInboundProfiles;
                    deserializedNspLinkReferenceProperties.remoteInboundProfiles = remoteInboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("remoteOutboundProfiles".equals(fieldName)) {
                    List remoteOutboundProfiles;
                    deserializedNspLinkReferenceProperties.remoteOutboundProfiles = remoteOutboundProfiles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedNspLinkReferenceProperties.description = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedNspLinkReferenceProperties.status = NspLinkStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNspLinkReferenceProperties;
        });
    }
}

