/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CircuitMetadataMap;
import com.azure.resourcemanager.network.models.GatewayRouteSet;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class GatewayRouteSetsInformationInner
implements JsonSerializable<GatewayRouteSetsInformationInner> {
    private OffsetDateTime lastComputedTime;
    private OffsetDateTime nextEligibleComputeTime;
    private String routeSetVersion;
    private List<GatewayRouteSet> routeSets;
    private Map<String, CircuitMetadataMap> circuitsMetadataMap;

    public OffsetDateTime lastComputedTime() {
        return this.lastComputedTime;
    }

    public GatewayRouteSetsInformationInner withLastComputedTime(OffsetDateTime lastComputedTime) {
        this.lastComputedTime = lastComputedTime;
        return this;
    }

    public OffsetDateTime nextEligibleComputeTime() {
        return this.nextEligibleComputeTime;
    }

    public GatewayRouteSetsInformationInner withNextEligibleComputeTime(OffsetDateTime nextEligibleComputeTime) {
        this.nextEligibleComputeTime = nextEligibleComputeTime;
        return this;
    }

    public String routeSetVersion() {
        return this.routeSetVersion;
    }

    public GatewayRouteSetsInformationInner withRouteSetVersion(String routeSetVersion) {
        this.routeSetVersion = routeSetVersion;
        return this;
    }

    public List<GatewayRouteSet> routeSets() {
        return this.routeSets;
    }

    public GatewayRouteSetsInformationInner withRouteSets(List<GatewayRouteSet> routeSets) {
        this.routeSets = routeSets;
        return this;
    }

    public Map<String, CircuitMetadataMap> circuitsMetadataMap() {
        return this.circuitsMetadataMap;
    }

    public GatewayRouteSetsInformationInner withCircuitsMetadataMap(Map<String, CircuitMetadataMap> circuitsMetadataMap) {
        this.circuitsMetadataMap = circuitsMetadataMap;
        return this;
    }

    public void validate() {
        if (this.routeSets() != null) {
            this.routeSets().forEach(e -> e.validate());
        }
        if (this.circuitsMetadataMap() != null) {
            this.circuitsMetadataMap().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastComputedTime", this.lastComputedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastComputedTime));
        jsonWriter.writeStringField("nextEligibleComputeTime", this.nextEligibleComputeTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextEligibleComputeTime));
        jsonWriter.writeStringField("routeSetVersion", this.routeSetVersion);
        jsonWriter.writeArrayField("routeSets", this.routeSets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("circuitsMetadataMap", this.circuitsMetadataMap, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static GatewayRouteSetsInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return (GatewayRouteSetsInformationInner)jsonReader.readObject(reader -> {
            GatewayRouteSetsInformationInner deserializedGatewayRouteSetsInformationInner = new GatewayRouteSetsInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastComputedTime".equals(fieldName)) {
                    deserializedGatewayRouteSetsInformationInner.lastComputedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("nextEligibleComputeTime".equals(fieldName)) {
                    deserializedGatewayRouteSetsInformationInner.nextEligibleComputeTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("routeSetVersion".equals(fieldName)) {
                    deserializedGatewayRouteSetsInformationInner.routeSetVersion = reader.getString();
                    continue;
                }
                if ("routeSets".equals(fieldName)) {
                    List routeSets;
                    deserializedGatewayRouteSetsInformationInner.routeSets = routeSets = reader.readArray(reader1 -> GatewayRouteSet.fromJson(reader1));
                    continue;
                }
                if ("circuitsMetadataMap".equals(fieldName)) {
                    Map circuitsMetadataMap;
                    deserializedGatewayRouteSetsInformationInner.circuitsMetadataMap = circuitsMetadataMap = reader.readMap(reader1 -> CircuitMetadataMap.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGatewayRouteSetsInformationInner;
        });
    }
}

