/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.AuthorizationPropertiesFormat;
import com.azure.resourcemanager.network.models.AuthorizationUseStatus;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ExpressRouteCircuitAuthorizationInner
extends SubResource {
    private AuthorizationPropertiesFormat innerProperties;
    private String name;
    private String etag;
    private String type;

    private AuthorizationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ExpressRouteCircuitAuthorizationInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public ExpressRouteCircuitAuthorizationInner withId(String id) {
        super.withId(id);
        return this;
    }

    public String authorizationKey() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizationKey();
    }

    public ExpressRouteCircuitAuthorizationInner withAuthorizationKey(String authorizationKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationPropertiesFormat();
        }
        this.innerProperties().withAuthorizationKey(authorizationKey);
        return this;
    }

    public AuthorizationUseStatus authorizationUseStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizationUseStatus();
    }

    public ExpressRouteCircuitAuthorizationInner withAuthorizationUseStatus(AuthorizationUseStatus authorizationUseStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationPropertiesFormat();
        }
        this.innerProperties().withAuthorizationUseStatus(authorizationUseStatus);
        return this;
    }

    public String connectionResourceUri() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionResourceUri();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteCircuitAuthorizationInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteCircuitAuthorizationInner)((Object)jsonReader.readObject(reader -> {
            ExpressRouteCircuitAuthorizationInner deserializedExpressRouteCircuitAuthorizationInner = new ExpressRouteCircuitAuthorizationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedExpressRouteCircuitAuthorizationInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExpressRouteCircuitAuthorizationInner.innerProperties = AuthorizationPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedExpressRouteCircuitAuthorizationInner.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedExpressRouteCircuitAuthorizationInner.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExpressRouteCircuitAuthorizationInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteCircuitAuthorizationInner;
        }));
    }
}

