/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ApplicationGatewayFrontendIpConfigurationPropertiesFormat
implements JsonSerializable<ApplicationGatewayFrontendIpConfigurationPropertiesFormat> {
    private String privateIpAddress;
    private IpAllocationMethod privateIpAllocationMethod;
    private SubResource subnet;
    private SubResource publicIpAddress;
    private SubResource privateLinkConfiguration;
    private ProvisioningState provisioningState;

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    public SubResource subnet() {
        return this.subnet;
    }

    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    public SubResource publicIpAddress() {
        return this.publicIpAddress;
    }

    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat withPublicIpAddress(SubResource publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    public SubResource privateLinkConfiguration() {
        return this.privateLinkConfiguration;
    }

    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat withPrivateLinkConfiguration(SubResource privateLinkConfiguration) {
        this.privateLinkConfiguration = privateLinkConfiguration;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateIPAddress", this.privateIpAddress);
        jsonWriter.writeStringField("privateIPAllocationMethod", this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        jsonWriter.writeJsonField("publicIPAddress", (JsonSerializable)this.publicIpAddress);
        jsonWriter.writeJsonField("privateLinkConfiguration", (JsonSerializable)this.privateLinkConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayFrontendIpConfigurationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayFrontendIpConfigurationPropertiesFormat)jsonReader.readObject(reader -> {
            ApplicationGatewayFrontendIpConfigurationPropertiesFormat deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat = new ApplicationGatewayFrontendIpConfigurationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateIPAddress".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat.privateIpAddress = reader.getString();
                    continue;
                }
                if ("privateIPAllocationMethod".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat.privateIpAllocationMethod = IpAllocationMethod.fromString(reader.getString());
                    continue;
                }
                if ("subnet".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat.subnet = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("publicIPAddress".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat.publicIpAddress = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("privateLinkConfiguration".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat.privateLinkConfiguration = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayFrontendIpConfigurationPropertiesFormat;
        });
    }
}

