/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.P2SConnectionConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnClientConnectionHealth;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class P2SVpnGatewayProperties {
    @JsonProperty(value="virtualHub")
    private SubResource virtualHub;
    @JsonProperty(value="p2SConnectionConfigurations")
    private List<P2SConnectionConfiguration> p2SConnectionConfigurations;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="vpnGatewayScaleUnit")
    private Integer vpnGatewayScaleUnit;
    @JsonProperty(value="vpnServerConfiguration")
    private SubResource vpnServerConfiguration;
    @JsonProperty(value="vpnClientConnectionHealth", access=JsonProperty.Access.WRITE_ONLY)
    private VpnClientConnectionHealth vpnClientConnectionHealth;
    @JsonProperty(value="customDnsServers")
    private List<String> customDnsServers;
    @JsonProperty(value="isRoutingPreferenceInternet")
    private Boolean isRoutingPreferenceInternet;

    public SubResource virtualHub() {
        return this.virtualHub;
    }

    public P2SVpnGatewayProperties withVirtualHub(SubResource virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public List<P2SConnectionConfiguration> p2SConnectionConfigurations() {
        return this.p2SConnectionConfigurations;
    }

    public P2SVpnGatewayProperties withP2SConnectionConfigurations(List<P2SConnectionConfiguration> p2SConnectionConfigurations) {
        this.p2SConnectionConfigurations = p2SConnectionConfigurations;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Integer vpnGatewayScaleUnit() {
        return this.vpnGatewayScaleUnit;
    }

    public P2SVpnGatewayProperties withVpnGatewayScaleUnit(Integer vpnGatewayScaleUnit) {
        this.vpnGatewayScaleUnit = vpnGatewayScaleUnit;
        return this;
    }

    public SubResource vpnServerConfiguration() {
        return this.vpnServerConfiguration;
    }

    public P2SVpnGatewayProperties withVpnServerConfiguration(SubResource vpnServerConfiguration) {
        this.vpnServerConfiguration = vpnServerConfiguration;
        return this;
    }

    public VpnClientConnectionHealth vpnClientConnectionHealth() {
        return this.vpnClientConnectionHealth;
    }

    public List<String> customDnsServers() {
        return this.customDnsServers;
    }

    public P2SVpnGatewayProperties withCustomDnsServers(List<String> customDnsServers) {
        this.customDnsServers = customDnsServers;
        return this;
    }

    public Boolean isRoutingPreferenceInternet() {
        return this.isRoutingPreferenceInternet;
    }

    public P2SVpnGatewayProperties withIsRoutingPreferenceInternet(Boolean isRoutingPreferenceInternet) {
        this.isRoutingPreferenceInternet = isRoutingPreferenceInternet;
        return this;
    }

    public void validate() {
        if (this.p2SConnectionConfigurations() != null) {
            this.p2SConnectionConfigurations().forEach(e -> e.validate());
        }
        if (this.vpnClientConnectionHealth() != null) {
            this.vpnClientConnectionHealth().validate();
        }
    }
}

