/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.models.GatewayLoadBalancerTunnelInterface;
import com.azure.resourcemanager.network.models.LoadBalancerBackendAddress;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SyncMode;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class BackendAddressPoolPropertiesFormat {
    @JsonProperty(value="location")
    private String location;
    @JsonProperty(value="tunnelInterfaces")
    private List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces;
    @JsonProperty(value="loadBalancerBackendAddresses")
    private List<LoadBalancerBackendAddress> loadBalancerBackendAddresses;
    @JsonProperty(value="backendIPConfigurations", access=JsonProperty.Access.WRITE_ONLY)
    private List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations;
    @JsonProperty(value="loadBalancingRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> loadBalancingRules;
    @JsonProperty(value="outboundRule", access=JsonProperty.Access.WRITE_ONLY)
    private SubResource outboundRule;
    @JsonProperty(value="outboundRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> outboundRules;
    @JsonProperty(value="inboundNatRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> inboundNatRules;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="drainPeriodInSeconds")
    private Integer drainPeriodInSeconds;
    @JsonProperty(value="virtualNetwork")
    private SubResource virtualNetwork;
    @JsonProperty(value="syncMode")
    private SyncMode syncMode;

    public String location() {
        return this.location;
    }

    public BackendAddressPoolPropertiesFormat withLocation(String location) {
        this.location = location;
        return this;
    }

    public List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces() {
        return this.tunnelInterfaces;
    }

    public BackendAddressPoolPropertiesFormat withTunnelInterfaces(List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces) {
        this.tunnelInterfaces = tunnelInterfaces;
        return this;
    }

    public List<LoadBalancerBackendAddress> loadBalancerBackendAddresses() {
        return this.loadBalancerBackendAddresses;
    }

    public BackendAddressPoolPropertiesFormat withLoadBalancerBackendAddresses(List<LoadBalancerBackendAddress> loadBalancerBackendAddresses) {
        this.loadBalancerBackendAddresses = loadBalancerBackendAddresses;
        return this;
    }

    public List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations() {
        return this.backendIpConfigurations;
    }

    public List<SubResource> loadBalancingRules() {
        return this.loadBalancingRules;
    }

    public SubResource outboundRule() {
        return this.outboundRule;
    }

    public List<SubResource> outboundRules() {
        return this.outboundRules;
    }

    public List<SubResource> inboundNatRules() {
        return this.inboundNatRules;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Integer drainPeriodInSeconds() {
        return this.drainPeriodInSeconds;
    }

    public BackendAddressPoolPropertiesFormat withDrainPeriodInSeconds(Integer drainPeriodInSeconds) {
        this.drainPeriodInSeconds = drainPeriodInSeconds;
        return this;
    }

    public SubResource virtualNetwork() {
        return this.virtualNetwork;
    }

    public BackendAddressPoolPropertiesFormat withVirtualNetwork(SubResource virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    public SyncMode syncMode() {
        return this.syncMode;
    }

    public BackendAddressPoolPropertiesFormat withSyncMode(SyncMode syncMode) {
        this.syncMode = syncMode;
        return this;
    }

    public void validate() {
        if (this.tunnelInterfaces() != null) {
            this.tunnelInterfaces().forEach(e -> e.validate());
        }
        if (this.loadBalancerBackendAddresses() != null) {
            this.loadBalancerBackendAddresses().forEach(e -> e.validate());
        }
        if (this.backendIpConfigurations() != null) {
            this.backendIpConfigurations().forEach(e -> e.validate());
        }
    }
}

