/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class MetricValue
implements JsonSerializable<MetricValue> {
    private OffsetDateTime timestamp;
    private Double average;
    private Double minimum;
    private Double maximum;
    private Double total;
    private Double count;
    private static final ClientLogger LOGGER = new ClientLogger(MetricValue.class);

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public MetricValue withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Double average() {
        return this.average;
    }

    public MetricValue withAverage(Double average) {
        this.average = average;
        return this;
    }

    public Double minimum() {
        return this.minimum;
    }

    public MetricValue withMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    public Double maximum() {
        return this.maximum;
    }

    public MetricValue withMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    public Double total() {
        return this.total;
    }

    public MetricValue withTotal(Double total) {
        this.total = total;
        return this;
    }

    public Double count() {
        return this.count;
    }

    public MetricValue withCount(Double count) {
        this.count = count;
        return this;
    }

    public void validate() {
        if (this.timestamp() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timestamp in model MetricValue"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeStamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeNumberField("average", (Number)this.average);
        jsonWriter.writeNumberField("minimum", (Number)this.minimum);
        jsonWriter.writeNumberField("maximum", (Number)this.maximum);
        jsonWriter.writeNumberField("total", (Number)this.total);
        jsonWriter.writeNumberField("count", (Number)this.count);
        return jsonWriter.writeEndObject();
    }

    public static MetricValue fromJson(JsonReader jsonReader) throws IOException {
        return (MetricValue)jsonReader.readObject(reader -> {
            MetricValue deserializedMetricValue = new MetricValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeStamp".equals(fieldName)) {
                    deserializedMetricValue.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("average".equals(fieldName)) {
                    deserializedMetricValue.average = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("minimum".equals(fieldName)) {
                    deserializedMetricValue.minimum = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("maximum".equals(fieldName)) {
                    deserializedMetricValue.maximum = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("total".equals(fieldName)) {
                    deserializedMetricValue.total = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedMetricValue.count = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricValue;
        });
    }
}

