/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.ExtensionDataSource;
import com.azure.resourcemanager.monitor.models.IisLogsDataSource;
import com.azure.resourcemanager.monitor.models.LogFilesDataSource;
import com.azure.resourcemanager.monitor.models.PerfCounterDataSource;
import com.azure.resourcemanager.monitor.models.SyslogDataSource;
import com.azure.resourcemanager.monitor.models.WindowsEventLogDataSource;
import java.io.IOException;
import java.util.List;

public class DataSourcesSpec
implements JsonSerializable<DataSourcesSpec> {
    private List<PerfCounterDataSource> performanceCounters;
    private List<WindowsEventLogDataSource> windowsEventLogs;
    private List<SyslogDataSource> syslog;
    private List<ExtensionDataSource> extensions;
    private List<LogFilesDataSource> logFiles;
    private List<IisLogsDataSource> iisLogs;

    public List<PerfCounterDataSource> performanceCounters() {
        return this.performanceCounters;
    }

    public DataSourcesSpec withPerformanceCounters(List<PerfCounterDataSource> performanceCounters) {
        this.performanceCounters = performanceCounters;
        return this;
    }

    public List<WindowsEventLogDataSource> windowsEventLogs() {
        return this.windowsEventLogs;
    }

    public DataSourcesSpec withWindowsEventLogs(List<WindowsEventLogDataSource> windowsEventLogs) {
        this.windowsEventLogs = windowsEventLogs;
        return this;
    }

    public List<SyslogDataSource> syslog() {
        return this.syslog;
    }

    public DataSourcesSpec withSyslog(List<SyslogDataSource> syslog) {
        this.syslog = syslog;
        return this;
    }

    public List<ExtensionDataSource> extensions() {
        return this.extensions;
    }

    public DataSourcesSpec withExtensions(List<ExtensionDataSource> extensions) {
        this.extensions = extensions;
        return this;
    }

    public List<LogFilesDataSource> logFiles() {
        return this.logFiles;
    }

    public DataSourcesSpec withLogFiles(List<LogFilesDataSource> logFiles) {
        this.logFiles = logFiles;
        return this;
    }

    public List<IisLogsDataSource> iisLogs() {
        return this.iisLogs;
    }

    public DataSourcesSpec withIisLogs(List<IisLogsDataSource> iisLogs) {
        this.iisLogs = iisLogs;
        return this;
    }

    public void validate() {
        if (this.performanceCounters() != null) {
            this.performanceCounters().forEach(e -> e.validate());
        }
        if (this.windowsEventLogs() != null) {
            this.windowsEventLogs().forEach(e -> e.validate());
        }
        if (this.syslog() != null) {
            this.syslog().forEach(e -> e.validate());
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
        if (this.logFiles() != null) {
            this.logFiles().forEach(e -> e.validate());
        }
        if (this.iisLogs() != null) {
            this.iisLogs().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("performanceCounters", this.performanceCounters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("windowsEventLogs", this.windowsEventLogs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("syslog", this.syslog, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("logFiles", this.logFiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("iisLogs", this.iisLogs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DataSourcesSpec fromJson(JsonReader jsonReader) throws IOException {
        return (DataSourcesSpec)jsonReader.readObject(reader -> {
            DataSourcesSpec deserializedDataSourcesSpec = new DataSourcesSpec();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("performanceCounters".equals(fieldName)) {
                    List performanceCounters;
                    deserializedDataSourcesSpec.performanceCounters = performanceCounters = reader.readArray(reader1 -> PerfCounterDataSource.fromJson(reader1));
                    continue;
                }
                if ("windowsEventLogs".equals(fieldName)) {
                    List windowsEventLogs;
                    deserializedDataSourcesSpec.windowsEventLogs = windowsEventLogs = reader.readArray(reader1 -> WindowsEventLogDataSource.fromJson(reader1));
                    continue;
                }
                if ("syslog".equals(fieldName)) {
                    List syslog;
                    deserializedDataSourcesSpec.syslog = syslog = reader.readArray(reader1 -> SyslogDataSource.fromJson(reader1));
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List extensions;
                    deserializedDataSourcesSpec.extensions = extensions = reader.readArray(reader1 -> ExtensionDataSource.fromJson(reader1));
                    continue;
                }
                if ("logFiles".equals(fieldName)) {
                    List logFiles;
                    deserializedDataSourcesSpec.logFiles = logFiles = reader.readArray(reader1 -> LogFilesDataSource.fromJson(reader1));
                    continue;
                }
                if ("iisLogs".equals(fieldName)) {
                    List iisLogs;
                    deserializedDataSourcesSpec.iisLogs = iisLogs = reader.readArray(reader1 -> IisLogsDataSource.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataSourcesSpec;
        });
    }
}

