/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.KnownPerfCounterDataSourceStreams;
import java.io.IOException;
import java.util.List;

public final class PerfCounterDataSource
implements JsonSerializable<PerfCounterDataSource> {
    private List<KnownPerfCounterDataSourceStreams> streams;
    private Integer samplingFrequencyInSeconds;
    private List<String> counterSpecifiers;
    private String name;

    public List<KnownPerfCounterDataSourceStreams> streams() {
        return this.streams;
    }

    public PerfCounterDataSource withStreams(List<KnownPerfCounterDataSourceStreams> streams) {
        this.streams = streams;
        return this;
    }

    public Integer samplingFrequencyInSeconds() {
        return this.samplingFrequencyInSeconds;
    }

    public PerfCounterDataSource withSamplingFrequencyInSeconds(Integer samplingFrequencyInSeconds) {
        this.samplingFrequencyInSeconds = samplingFrequencyInSeconds;
        return this;
    }

    public List<String> counterSpecifiers() {
        return this.counterSpecifiers;
    }

    public PerfCounterDataSource withCounterSpecifiers(List<String> counterSpecifiers) {
        this.counterSpecifiers = counterSpecifiers;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PerfCounterDataSource withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("streams", this.streams, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeNumberField("samplingFrequencyInSeconds", (Number)this.samplingFrequencyInSeconds);
        jsonWriter.writeArrayField("counterSpecifiers", this.counterSpecifiers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static PerfCounterDataSource fromJson(JsonReader jsonReader) throws IOException {
        return (PerfCounterDataSource)jsonReader.readObject(reader -> {
            PerfCounterDataSource deserializedPerfCounterDataSource = new PerfCounterDataSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("streams".equals(fieldName)) {
                    List streams;
                    deserializedPerfCounterDataSource.streams = streams = reader.readArray(reader1 -> KnownPerfCounterDataSourceStreams.fromString(reader1.getString()));
                    continue;
                }
                if ("samplingFrequencyInSeconds".equals(fieldName)) {
                    deserializedPerfCounterDataSource.samplingFrequencyInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("counterSpecifiers".equals(fieldName)) {
                    List counterSpecifiers;
                    deserializedPerfCounterDataSource.counterSpecifiers = counterSpecifiers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPerfCounterDataSource.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPerfCounterDataSource;
        });
    }
}

