/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.AggregationTypeEnum;
import com.azure.resourcemanager.monitor.models.CriterionType;
import com.azure.resourcemanager.monitor.models.DynamicMetricCriteria;
import com.azure.resourcemanager.monitor.models.MetricCriteria;
import com.azure.resourcemanager.monitor.models.MetricDimension;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MultiMetricCriteria
implements JsonSerializable<MultiMetricCriteria> {
    private CriterionType criterionType = CriterionType.fromString("MultiMetricCriteria");
    private String name;
    private String metricName;
    private String metricNamespace;
    private AggregationTypeEnum timeAggregation;
    private List<MetricDimension> dimensions;
    private Boolean skipMetricValidation;
    private Map<String, Object> additionalProperties;
    private static final ClientLogger LOGGER = new ClientLogger(MultiMetricCriteria.class);

    public CriterionType criterionType() {
        return this.criterionType;
    }

    public String name() {
        return this.name;
    }

    public MultiMetricCriteria withName(String name) {
        this.name = name;
        return this;
    }

    public String metricName() {
        return this.metricName;
    }

    public MultiMetricCriteria withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public String metricNamespace() {
        return this.metricNamespace;
    }

    public MultiMetricCriteria withMetricNamespace(String metricNamespace) {
        this.metricNamespace = metricNamespace;
        return this;
    }

    public AggregationTypeEnum timeAggregation() {
        return this.timeAggregation;
    }

    public MultiMetricCriteria withTimeAggregation(AggregationTypeEnum timeAggregation) {
        this.timeAggregation = timeAggregation;
        return this;
    }

    public List<MetricDimension> dimensions() {
        return this.dimensions;
    }

    public MultiMetricCriteria withDimensions(List<MetricDimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public Boolean skipMetricValidation() {
        return this.skipMetricValidation;
    }

    public MultiMetricCriteria withSkipMetricValidation(Boolean skipMetricValidation) {
        this.skipMetricValidation = skipMetricValidation;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MultiMetricCriteria withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model MultiMetricCriteria"));
        }
        if (this.metricName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property metricName in model MultiMetricCriteria"));
        }
        if (this.timeAggregation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timeAggregation in model MultiMetricCriteria"));
        }
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("metricName", this.metricName);
        jsonWriter.writeStringField("timeAggregation", this.timeAggregation == null ? null : this.timeAggregation.toString());
        jsonWriter.writeStringField("criterionType", this.criterionType == null ? null : this.criterionType.toString());
        jsonWriter.writeStringField("metricNamespace", this.metricNamespace);
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("skipMetricValidation", this.skipMetricValidation);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MultiMetricCriteria fromJson(JsonReader jsonReader) throws IOException {
        return (MultiMetricCriteria)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                MultiMetricCriteria multiMetricCriteria;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("criterionType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("StaticThresholdCriterion".equals(discriminatorValue)) {
                    multiMetricCriteria = MetricCriteria.fromJson(readerToUse.reset());
                    return multiMetricCriteria;
                }
                if ("DynamicThresholdCriterion".equals(discriminatorValue)) {
                    multiMetricCriteria = DynamicMetricCriteria.fromJson(readerToUse.reset());
                    return multiMetricCriteria;
                }
                multiMetricCriteria = MultiMetricCriteria.fromJsonKnownDiscriminator(readerToUse.reset());
                return multiMetricCriteria;
            }
        });
    }

    static MultiMetricCriteria fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (MultiMetricCriteria)jsonReader.readObject(reader -> {
            MultiMetricCriteria deserializedMultiMetricCriteria = new MultiMetricCriteria();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMultiMetricCriteria.name = reader.getString();
                    continue;
                }
                if ("metricName".equals(fieldName)) {
                    deserializedMultiMetricCriteria.metricName = reader.getString();
                    continue;
                }
                if ("timeAggregation".equals(fieldName)) {
                    deserializedMultiMetricCriteria.timeAggregation = AggregationTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("criterionType".equals(fieldName)) {
                    deserializedMultiMetricCriteria.criterionType = CriterionType.fromString(reader.getString());
                    continue;
                }
                if ("metricNamespace".equals(fieldName)) {
                    deserializedMultiMetricCriteria.metricNamespace = reader.getString();
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List dimensions;
                    deserializedMultiMetricCriteria.dimensions = dimensions = reader.readArray(reader1 -> MetricDimension.fromJson(reader1));
                    continue;
                }
                if ("skipMetricValidation".equals(fieldName)) {
                    deserializedMultiMetricCriteria.skipMetricValidation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMultiMetricCriteria.additionalProperties = additionalProperties;
            return deserializedMultiMetricCriteria;
        });
    }
}

