/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.RetentionPolicy;
import java.io.IOException;
import java.time.Duration;

public final class MetricSettings
implements JsonSerializable<MetricSettings> {
    private Duration timeGrain;
    private String category;
    private boolean enabled;
    private RetentionPolicy retentionPolicy;

    public Duration timeGrain() {
        return this.timeGrain;
    }

    public MetricSettings withTimeGrain(Duration timeGrain) {
        this.timeGrain = timeGrain;
        return this;
    }

    public String category() {
        return this.category;
    }

    public MetricSettings withCategory(String category) {
        this.category = category;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public MetricSettings withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    public MetricSettings withRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public void validate() {
        if (this.retentionPolicy() != null) {
            this.retentionPolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("timeGrain", CoreUtils.durationToStringWithDays((Duration)this.timeGrain));
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeJsonField("retentionPolicy", (JsonSerializable)this.retentionPolicy);
        return jsonWriter.writeEndObject();
    }

    public static MetricSettings fromJson(JsonReader jsonReader) throws IOException {
        return (MetricSettings)jsonReader.readObject(reader -> {
            MetricSettings deserializedMetricSettings = new MetricSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedMetricSettings.enabled = reader.getBoolean();
                    continue;
                }
                if ("timeGrain".equals(fieldName)) {
                    deserializedMetricSettings.timeGrain = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedMetricSettings.category = reader.getString();
                    continue;
                }
                if ("retentionPolicy".equals(fieldName)) {
                    deserializedMetricSettings.retentionPolicy = RetentionPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricSettings;
        });
    }
}

