/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.LogProfileResourceInner;
import java.io.IOException;
import java.util.List;

public final class LogProfileCollection
implements JsonSerializable<LogProfileCollection> {
    private List<LogProfileResourceInner> value;
    private static final ClientLogger LOGGER = new ClientLogger(LogProfileCollection.class);

    public List<LogProfileResourceInner> value() {
        return this.value;
    }

    public LogProfileCollection withValue(List<LogProfileResourceInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model LogProfileCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static LogProfileCollection fromJson(JsonReader jsonReader) throws IOException {
        return (LogProfileCollection)jsonReader.readObject(reader -> {
            LogProfileCollection deserializedLogProfileCollection = new LogProfileCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedLogProfileCollection.value = value = reader.readArray(reader1 -> LogProfileResourceInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogProfileCollection;
        });
    }
}

