/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class EventHubReceiver
implements JsonSerializable<EventHubReceiver> {
    private String name;
    private String eventHubNameSpace;
    private String eventHubName;
    private Boolean useCommonAlertSchema;
    private String tenantId;
    private String subscriptionId;
    private static final ClientLogger LOGGER = new ClientLogger(EventHubReceiver.class);

    public String name() {
        return this.name;
    }

    public EventHubReceiver withName(String name) {
        this.name = name;
        return this;
    }

    public String eventHubNameSpace() {
        return this.eventHubNameSpace;
    }

    public EventHubReceiver withEventHubNameSpace(String eventHubNameSpace) {
        this.eventHubNameSpace = eventHubNameSpace;
        return this;
    }

    public String eventHubName() {
        return this.eventHubName;
    }

    public EventHubReceiver withEventHubName(String eventHubName) {
        this.eventHubName = eventHubName;
        return this;
    }

    public Boolean useCommonAlertSchema() {
        return this.useCommonAlertSchema;
    }

    public EventHubReceiver withUseCommonAlertSchema(Boolean useCommonAlertSchema) {
        this.useCommonAlertSchema = useCommonAlertSchema;
        return this;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public EventHubReceiver withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public EventHubReceiver withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model EventHubReceiver"));
        }
        if (this.eventHubNameSpace() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property eventHubNameSpace in model EventHubReceiver"));
        }
        if (this.eventHubName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property eventHubName in model EventHubReceiver"));
        }
        if (this.subscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionId in model EventHubReceiver"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("eventHubNameSpace", this.eventHubNameSpace);
        jsonWriter.writeStringField("eventHubName", this.eventHubName);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeBooleanField("useCommonAlertSchema", this.useCommonAlertSchema);
        jsonWriter.writeStringField("tenantId", this.tenantId);
        return jsonWriter.writeEndObject();
    }

    public static EventHubReceiver fromJson(JsonReader jsonReader) throws IOException {
        return (EventHubReceiver)jsonReader.readObject(reader -> {
            EventHubReceiver deserializedEventHubReceiver = new EventHubReceiver();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedEventHubReceiver.name = reader.getString();
                    continue;
                }
                if ("eventHubNameSpace".equals(fieldName)) {
                    deserializedEventHubReceiver.eventHubNameSpace = reader.getString();
                    continue;
                }
                if ("eventHubName".equals(fieldName)) {
                    deserializedEventHubReceiver.eventHubName = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedEventHubReceiver.subscriptionId = reader.getString();
                    continue;
                }
                if ("useCommonAlertSchema".equals(fieldName)) {
                    deserializedEventHubReceiver.useCommonAlertSchema = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedEventHubReceiver.tenantId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventHubReceiver;
        });
    }
}

