/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.DimensionOperator;
import java.io.IOException;
import java.util.List;

public final class Dimension
implements JsonSerializable<Dimension> {
    private String name;
    private DimensionOperator operator;
    private List<String> values;
    private static final ClientLogger LOGGER = new ClientLogger(Dimension.class);

    public String name() {
        return this.name;
    }

    public Dimension withName(String name) {
        this.name = name;
        return this;
    }

    public DimensionOperator operator() {
        return this.operator;
    }

    public Dimension withOperator(DimensionOperator operator) {
        this.operator = operator;
        return this;
    }

    public List<String> values() {
        return this.values;
    }

    public Dimension withValues(List<String> values) {
        this.values = values;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model Dimension"));
        }
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model Dimension"));
        }
        if (this.values() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property values in model Dimension"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static Dimension fromJson(JsonReader jsonReader) throws IOException {
        return (Dimension)jsonReader.readObject(reader -> {
            Dimension deserializedDimension = new Dimension();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDimension.name = reader.getString();
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedDimension.operator = DimensionOperator.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedDimension.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDimension;
        });
    }
}

