/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.MetricNamespaceName;
import com.azure.resourcemanager.monitor.models.NamespaceClassification;
import java.io.IOException;

public final class MetricNamespaceInner
implements JsonSerializable<MetricNamespaceInner> {
    private String id;
    private String type;
    private String name;
    private NamespaceClassification classification;
    private MetricNamespaceName properties;

    public String id() {
        return this.id;
    }

    public MetricNamespaceInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public MetricNamespaceInner withType(String type) {
        this.type = type;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MetricNamespaceInner withName(String name) {
        this.name = name;
        return this;
    }

    public NamespaceClassification classification() {
        return this.classification;
    }

    public MetricNamespaceInner withClassification(NamespaceClassification classification) {
        this.classification = classification;
        return this;
    }

    public MetricNamespaceName properties() {
        return this.properties;
    }

    public MetricNamespaceInner withProperties(MetricNamespaceName properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("classification", this.classification == null ? null : this.classification.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static MetricNamespaceInner fromJson(JsonReader jsonReader) throws IOException {
        return (MetricNamespaceInner)jsonReader.readObject(reader -> {
            MetricNamespaceInner deserializedMetricNamespaceInner = new MetricNamespaceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMetricNamespaceInner.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMetricNamespaceInner.type = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMetricNamespaceInner.name = reader.getString();
                    continue;
                }
                if ("classification".equals(fieldName)) {
                    deserializedMetricNamespaceInner.classification = NamespaceClassification.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMetricNamespaceInner.properties = MetricNamespaceName.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricNamespaceInner;
        });
    }
}

