/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.ActionList;
import com.azure.resourcemanager.monitor.models.ActivityLogAlertAllOfCondition;
import java.io.IOException;
import java.util.List;

public final class AlertRuleProperties
implements JsonSerializable<AlertRuleProperties> {
    private List<String> scopes;
    private ActivityLogAlertAllOfCondition condition;
    private ActionList actions;
    private Boolean enabled;
    private String description;
    private static final ClientLogger LOGGER = new ClientLogger(AlertRuleProperties.class);

    public List<String> scopes() {
        return this.scopes;
    }

    public AlertRuleProperties withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public ActivityLogAlertAllOfCondition condition() {
        return this.condition;
    }

    public AlertRuleProperties withCondition(ActivityLogAlertAllOfCondition condition) {
        this.condition = condition;
        return this;
    }

    public ActionList actions() {
        return this.actions;
    }

    public AlertRuleProperties withActions(ActionList actions) {
        this.actions = actions;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public AlertRuleProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String description() {
        return this.description;
    }

    public AlertRuleProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.scopes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scopes in model AlertRuleProperties"));
        }
        if (this.condition() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property condition in model AlertRuleProperties"));
        }
        this.condition().validate();
        if (this.actions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property actions in model AlertRuleProperties"));
        }
        this.actions().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("scopes", this.scopes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("condition", (JsonSerializable)this.condition);
        jsonWriter.writeJsonField("actions", (JsonSerializable)this.actions);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static AlertRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AlertRuleProperties)jsonReader.readObject(reader -> {
            AlertRuleProperties deserializedAlertRuleProperties = new AlertRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scopes".equals(fieldName)) {
                    List scopes;
                    deserializedAlertRuleProperties.scopes = scopes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("condition".equals(fieldName)) {
                    deserializedAlertRuleProperties.condition = ActivityLogAlertAllOfCondition.fromJson(reader);
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    deserializedAlertRuleProperties.actions = ActionList.fromJson(reader);
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedAlertRuleProperties.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAlertRuleProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAlertRuleProperties;
        });
    }
}

