// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

/**
 * the predictive autoscale mode.
 */
public enum PredictiveAutoscalePolicyScaleMode {
    /**
     * Enum value Disabled.
     */
    DISABLED("Disabled"),

    /**
     * Enum value ForecastOnly.
     */
    FORECAST_ONLY("ForecastOnly"),

    /**
     * Enum value Enabled.
     */
    ENABLED("Enabled");

    /**
     * The actual serialized value for a PredictiveAutoscalePolicyScaleMode instance.
     */
    private final String value;

    PredictiveAutoscalePolicyScaleMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a PredictiveAutoscalePolicyScaleMode instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed PredictiveAutoscalePolicyScaleMode object, or null if unable to parse.
     */
    public static PredictiveAutoscalePolicyScaleMode fromString(String value) {
        if (value == null) {
            return null;
        }
        PredictiveAutoscalePolicyScaleMode[] items = PredictiveAutoscalePolicyScaleMode.values();
        for (PredictiveAutoscalePolicyScaleMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
