// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

/**
 * the metric statistic type. How the metrics from multiple instances are combined.
 */
public enum MetricStatisticType {
    /**
     * Enum value Average.
     */
    AVERAGE("Average"),

    /**
     * Enum value Min.
     */
    MIN("Min"),

    /**
     * Enum value Max.
     */
    MAX("Max"),

    /**
     * Enum value Sum.
     */
    SUM("Sum"),

    /**
     * Enum value Count.
     */
    COUNT("Count");

    /**
     * The actual serialized value for a MetricStatisticType instance.
     */
    private final String value;

    MetricStatisticType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a MetricStatisticType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed MetricStatisticType object, or null if unable to parse.
     */
    public static MetricStatisticType fromString(String value) {
        if (value == null) {
            return null;
        }
        MetricStatisticType[] items = MetricStatisticType.values();
        for (MetricStatisticType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
