// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

/**
 * Metric availability specifies the time grain (aggregation interval or frequency) and the retention period for that
 * time grain.
 */
@Fluent
public final class MetricAvailability implements JsonSerializable<MetricAvailability> {
    /*
     * the time grain specifies the aggregation interval for the metric. Expressed as a duration 'PT1M', 'P1D', etc.
     */
    private Duration timeGrain;

    /*
     * the retention period for the metric at the specified timegrain. Expressed as a duration 'PT1M', 'P1D', etc.
     */
    private Duration retention;

    /**
     * Creates an instance of MetricAvailability class.
     */
    public MetricAvailability() {
    }

    /**
     * Get the timeGrain property: the time grain specifies the aggregation interval for the metric. Expressed as a
     * duration 'PT1M', 'P1D', etc.
     * 
     * @return the timeGrain value.
     */
    public Duration timeGrain() {
        return this.timeGrain;
    }

    /**
     * Set the timeGrain property: the time grain specifies the aggregation interval for the metric. Expressed as a
     * duration 'PT1M', 'P1D', etc.
     * 
     * @param timeGrain the timeGrain value to set.
     * @return the MetricAvailability object itself.
     */
    public MetricAvailability withTimeGrain(Duration timeGrain) {
        this.timeGrain = timeGrain;
        return this;
    }

    /**
     * Get the retention property: the retention period for the metric at the specified timegrain. Expressed as a
     * duration 'PT1M', 'P1D', etc.
     * 
     * @return the retention value.
     */
    public Duration retention() {
        return this.retention;
    }

    /**
     * Set the retention property: the retention period for the metric at the specified timegrain. Expressed as a
     * duration 'PT1M', 'P1D', etc.
     * 
     * @param retention the retention value to set.
     * @return the MetricAvailability object itself.
     */
    public MetricAvailability withRetention(Duration retention) {
        this.retention = retention;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeGrain", CoreUtils.durationToStringWithDays(this.timeGrain));
        jsonWriter.writeStringField("retention", CoreUtils.durationToStringWithDays(this.retention));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricAvailability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricAvailability if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MetricAvailability.
     */
    public static MetricAvailability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricAvailability deserializedMetricAvailability = new MetricAvailability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timeGrain".equals(fieldName)) {
                    deserializedMetricAvailability.timeGrain
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("retention".equals(fieldName)) {
                    deserializedMetricAvailability.retention
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricAvailability;
        });
    }
}
