// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * An alert status properties.
 */
@Fluent
public final class MetricAlertStatusProperties implements JsonSerializable<MetricAlertStatusProperties> {
    /*
     * An object describing the type of the dimensions.
     */
    private Map<String, String> dimensions;

    /*
     * status value
     */
    private String status;

    /*
     * UTC time when the status was checked.
     */
    private OffsetDateTime timestamp;

    /**
     * Creates an instance of MetricAlertStatusProperties class.
     */
    public MetricAlertStatusProperties() {
    }

    /**
     * Get the dimensions property: An object describing the type of the dimensions.
     * 
     * @return the dimensions value.
     */
    public Map<String, String> dimensions() {
        return this.dimensions;
    }

    /**
     * Set the dimensions property: An object describing the type of the dimensions.
     * 
     * @param dimensions the dimensions value to set.
     * @return the MetricAlertStatusProperties object itself.
     */
    public MetricAlertStatusProperties withDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    /**
     * Get the status property: status value.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: status value.
     * 
     * @param status the status value to set.
     * @return the MetricAlertStatusProperties object itself.
     */
    public MetricAlertStatusProperties withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the timestamp property: UTC time when the status was checked.
     * 
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: UTC time when the status was checked.
     * 
     * @param timestamp the timestamp value to set.
     * @return the MetricAlertStatusProperties object itself.
     */
    public MetricAlertStatusProperties withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("dimensions", this.dimensions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("timestamp",
            this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricAlertStatusProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricAlertStatusProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MetricAlertStatusProperties.
     */
    public static MetricAlertStatusProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricAlertStatusProperties deserializedMetricAlertStatusProperties = new MetricAlertStatusProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dimensions".equals(fieldName)) {
                    Map<String, String> dimensions = reader.readMap(reader1 -> reader1.getString());
                    deserializedMetricAlertStatusProperties.dimensions = dimensions;
                } else if ("status".equals(fieldName)) {
                    deserializedMetricAlertStatusProperties.status = reader.getString();
                } else if ("timestamp".equals(fieldName)) {
                    deserializedMetricAlertStatusProperties.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricAlertStatusProperties;
        });
    }
}
