// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Settings for text log files.
 */
@Fluent
public class LogFileTextSettings implements JsonSerializable<LogFileTextSettings> {
    /*
     * One of the supported timestamp formats
     */
    private KnownLogFileTextSettingsRecordStartTimestampFormat recordStartTimestampFormat;

    /**
     * Creates an instance of LogFileTextSettings class.
     */
    public LogFileTextSettings() {
    }

    /**
     * Get the recordStartTimestampFormat property: One of the supported timestamp formats.
     * 
     * @return the recordStartTimestampFormat value.
     */
    public KnownLogFileTextSettingsRecordStartTimestampFormat recordStartTimestampFormat() {
        return this.recordStartTimestampFormat;
    }

    /**
     * Set the recordStartTimestampFormat property: One of the supported timestamp formats.
     * 
     * @param recordStartTimestampFormat the recordStartTimestampFormat value to set.
     * @return the LogFileTextSettings object itself.
     */
    public LogFileTextSettings
        withRecordStartTimestampFormat(KnownLogFileTextSettingsRecordStartTimestampFormat recordStartTimestampFormat) {
        this.recordStartTimestampFormat = recordStartTimestampFormat;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (recordStartTimestampFormat() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property recordStartTimestampFormat in model LogFileTextSettings"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LogFileTextSettings.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recordStartTimestampFormat",
            this.recordStartTimestampFormat == null ? null : this.recordStartTimestampFormat.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogFileTextSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogFileTextSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LogFileTextSettings.
     */
    public static LogFileTextSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogFileTextSettings deserializedLogFileTextSettings = new LogFileTextSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("recordStartTimestampFormat".equals(fieldName)) {
                    deserializedLogFileTextSettings.recordStartTimestampFormat
                        = KnownLogFileTextSettingsRecordStartTimestampFormat.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogFileTextSettings;
        });
    }
}
