// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.EventDataInner;
import java.io.IOException;
import java.util.List;

/**
 * Represents collection of events.
 */
@Fluent
public final class EventDataCollection implements JsonSerializable<EventDataCollection> {
    /*
     * this list that includes the Azure audit logs.
     */
    private List<EventDataInner> value;

    /*
     * Provides the link to retrieve the next set of events.
     */
    private String nextLink;

    /**
     * Creates an instance of EventDataCollection class.
     */
    public EventDataCollection() {
    }

    /**
     * Get the value property: this list that includes the Azure audit logs.
     * 
     * @return the value value.
     */
    public List<EventDataInner> value() {
        return this.value;
    }

    /**
     * Set the value property: this list that includes the Azure audit logs.
     * 
     * @param value the value value to set.
     * @return the EventDataCollection object itself.
     */
    public EventDataCollection withValue(List<EventDataInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Provides the link to retrieve the next set of events.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Provides the link to retrieve the next set of events.
     * 
     * @param nextLink the nextLink value to set.
     * @return the EventDataCollection object itself.
     */
    public EventDataCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model EventDataCollection"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(EventDataCollection.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EventDataCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EventDataCollection if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EventDataCollection.
     */
    public static EventDataCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventDataCollection deserializedEventDataCollection = new EventDataCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<EventDataInner> value = reader.readArray(reader1 -> EventDataInner.fromJson(reader1));
                    deserializedEventDataCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedEventDataCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEventDataCollection;
        });
    }
}
