// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An email receiver.
 */
@Fluent
public final class EmailReceiver implements JsonSerializable<EmailReceiver> {
    /*
     * The name of the email receiver. Names must be unique across all receivers within an action group.
     */
    private String name;

    /*
     * The email address of this receiver.
     */
    private String emailAddress;

    /*
     * Indicates whether to use common alert schema.
     */
    private Boolean useCommonAlertSchema;

    /*
     * The receiver status of the e-mail.
     */
    private ReceiverStatus status;

    /**
     * Creates an instance of EmailReceiver class.
     */
    public EmailReceiver() {
    }

    /**
     * Get the name property: The name of the email receiver. Names must be unique across all receivers within an action
     * group.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the email receiver. Names must be unique across all receivers within an action
     * group.
     * 
     * @param name the name value to set.
     * @return the EmailReceiver object itself.
     */
    public EmailReceiver withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the emailAddress property: The email address of this receiver.
     * 
     * @return the emailAddress value.
     */
    public String emailAddress() {
        return this.emailAddress;
    }

    /**
     * Set the emailAddress property: The email address of this receiver.
     * 
     * @param emailAddress the emailAddress value to set.
     * @return the EmailReceiver object itself.
     */
    public EmailReceiver withEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    /**
     * Get the useCommonAlertSchema property: Indicates whether to use common alert schema.
     * 
     * @return the useCommonAlertSchema value.
     */
    public Boolean useCommonAlertSchema() {
        return this.useCommonAlertSchema;
    }

    /**
     * Set the useCommonAlertSchema property: Indicates whether to use common alert schema.
     * 
     * @param useCommonAlertSchema the useCommonAlertSchema value to set.
     * @return the EmailReceiver object itself.
     */
    public EmailReceiver withUseCommonAlertSchema(Boolean useCommonAlertSchema) {
        this.useCommonAlertSchema = useCommonAlertSchema;
        return this;
    }

    /**
     * Get the status property: The receiver status of the e-mail.
     * 
     * @return the status value.
     */
    public ReceiverStatus status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model EmailReceiver"));
        }
        if (emailAddress() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property emailAddress in model EmailReceiver"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(EmailReceiver.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("emailAddress", this.emailAddress);
        jsonWriter.writeBooleanField("useCommonAlertSchema", this.useCommonAlertSchema);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EmailReceiver from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EmailReceiver if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EmailReceiver.
     */
    public static EmailReceiver fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EmailReceiver deserializedEmailReceiver = new EmailReceiver();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedEmailReceiver.name = reader.getString();
                } else if ("emailAddress".equals(fieldName)) {
                    deserializedEmailReceiver.emailAddress = reader.getString();
                } else if ("useCommonAlertSchema".equals(fieldName)) {
                    deserializedEmailReceiver.useCommonAlertSchema = reader.getNullable(JsonReader::getBoolean);
                } else if ("status".equals(fieldName)) {
                    deserializedEmailReceiver.status = ReceiverStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEmailReceiver;
        });
    }
}
