// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The specification of data sources.
 * This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned
 * endpoint.
 */
@Fluent
public final class DataCollectionRuleDataSources extends DataSourcesSpec {
    /**
     * Creates an instance of DataCollectionRuleDataSources class.
     */
    public DataCollectionRuleDataSources() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DataCollectionRuleDataSources withPerformanceCounters(List<PerfCounterDataSource> performanceCounters) {
        super.withPerformanceCounters(performanceCounters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DataCollectionRuleDataSources withWindowsEventLogs(List<WindowsEventLogDataSource> windowsEventLogs) {
        super.withWindowsEventLogs(windowsEventLogs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DataCollectionRuleDataSources withSyslog(List<SyslogDataSource> syslog) {
        super.withSyslog(syslog);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DataCollectionRuleDataSources withExtensions(List<ExtensionDataSource> extensions) {
        super.withExtensions(extensions);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DataCollectionRuleDataSources withLogFiles(List<LogFilesDataSource> logFiles) {
        super.withLogFiles(logFiles);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DataCollectionRuleDataSources withIisLogs(List<IisLogsDataSource> iisLogs) {
        super.withIisLogs(iisLogs);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("performanceCounters", performanceCounters(),
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("windowsEventLogs", windowsEventLogs(),
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("syslog", syslog(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("extensions", extensions(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("logFiles", logFiles(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("iisLogs", iisLogs(), (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataCollectionRuleDataSources from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataCollectionRuleDataSources if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DataCollectionRuleDataSources.
     */
    public static DataCollectionRuleDataSources fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataCollectionRuleDataSources deserializedDataCollectionRuleDataSources
                = new DataCollectionRuleDataSources();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("performanceCounters".equals(fieldName)) {
                    List<PerfCounterDataSource> performanceCounters
                        = reader.readArray(reader1 -> PerfCounterDataSource.fromJson(reader1));
                    deserializedDataCollectionRuleDataSources.withPerformanceCounters(performanceCounters);
                } else if ("windowsEventLogs".equals(fieldName)) {
                    List<WindowsEventLogDataSource> windowsEventLogs
                        = reader.readArray(reader1 -> WindowsEventLogDataSource.fromJson(reader1));
                    deserializedDataCollectionRuleDataSources.withWindowsEventLogs(windowsEventLogs);
                } else if ("syslog".equals(fieldName)) {
                    List<SyslogDataSource> syslog = reader.readArray(reader1 -> SyslogDataSource.fromJson(reader1));
                    deserializedDataCollectionRuleDataSources.withSyslog(syslog);
                } else if ("extensions".equals(fieldName)) {
                    List<ExtensionDataSource> extensions
                        = reader.readArray(reader1 -> ExtensionDataSource.fromJson(reader1));
                    deserializedDataCollectionRuleDataSources.withExtensions(extensions);
                } else if ("logFiles".equals(fieldName)) {
                    List<LogFilesDataSource> logFiles
                        = reader.readArray(reader1 -> LogFilesDataSource.fromJson(reader1));
                    deserializedDataCollectionRuleDataSources.withLogFiles(logFiles);
                } else if ("iisLogs".equals(fieldName)) {
                    List<IisLogsDataSource> iisLogs = reader.readArray(reader1 -> IisLogsDataSource.fromJson(reader1));
                    deserializedDataCollectionRuleDataSources.withIisLogs(iisLogs);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataCollectionRuleDataSources;
        });
    }
}
