// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

/**
 * The response to a metrics query.
 */
@Fluent
public final class ResponseInner implements JsonSerializable<ResponseInner> {
    /*
     * The integer value representing the relative cost of the query.
     */
    private Integer cost;

    /*
     * The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by
     * '/'. This may be adjusted in the future and returned back from what was originally requested.
     */
    private String timespan;

    /*
     * The interval (window size) for which the metric data was returned in. This may be adjusted in the future and
     * returned back from what was originally requested. This is not present if a metadata request was made.
     */
    private Duration interval;

    /*
     * The namespace of the metrics being queried
     */
    private String namespace;

    /*
     * The region of the resource being queried for metrics.
     */
    private String resourceRegion;

    /*
     * the value of the collection.
     */
    private List<MetricInner> value;

    /**
     * Creates an instance of ResponseInner class.
     */
    public ResponseInner() {
    }

    /**
     * Get the cost property: The integer value representing the relative cost of the query.
     * 
     * @return the cost value.
     */
    public Integer cost() {
        return this.cost;
    }

    /**
     * Set the cost property: The integer value representing the relative cost of the query.
     * 
     * @param cost the cost value to set.
     * @return the ResponseInner object itself.
     */
    public ResponseInner withCost(Integer cost) {
        this.cost = cost;
        return this;
    }

    /**
     * Get the timespan property: The timespan for which the data was retrieved. Its value consists of two datetimes
     * concatenated, separated by '/'. This may be adjusted in the future and returned back from what was originally
     * requested.
     * 
     * @return the timespan value.
     */
    public String timespan() {
        return this.timespan;
    }

    /**
     * Set the timespan property: The timespan for which the data was retrieved. Its value consists of two datetimes
     * concatenated, separated by '/'. This may be adjusted in the future and returned back from what was originally
     * requested.
     * 
     * @param timespan the timespan value to set.
     * @return the ResponseInner object itself.
     */
    public ResponseInner withTimespan(String timespan) {
        this.timespan = timespan;
        return this;
    }

    /**
     * Get the interval property: The interval (window size) for which the metric data was returned in. This may be
     * adjusted in the future and returned back from what was originally requested. This is not present if a metadata
     * request was made.
     * 
     * @return the interval value.
     */
    public Duration interval() {
        return this.interval;
    }

    /**
     * Set the interval property: The interval (window size) for which the metric data was returned in. This may be
     * adjusted in the future and returned back from what was originally requested. This is not present if a metadata
     * request was made.
     * 
     * @param interval the interval value to set.
     * @return the ResponseInner object itself.
     */
    public ResponseInner withInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Get the namespace property: The namespace of the metrics being queried.
     * 
     * @return the namespace value.
     */
    public String namespace() {
        return this.namespace;
    }

    /**
     * Set the namespace property: The namespace of the metrics being queried.
     * 
     * @param namespace the namespace value to set.
     * @return the ResponseInner object itself.
     */
    public ResponseInner withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    /**
     * Get the resourceRegion property: The region of the resource being queried for metrics.
     * 
     * @return the resourceRegion value.
     */
    public String resourceRegion() {
        return this.resourceRegion;
    }

    /**
     * Set the resourceRegion property: The region of the resource being queried for metrics.
     * 
     * @param resourceRegion the resourceRegion value to set.
     * @return the ResponseInner object itself.
     */
    public ResponseInner withResourceRegion(String resourceRegion) {
        this.resourceRegion = resourceRegion;
        return this;
    }

    /**
     * Get the value property: the value of the collection.
     * 
     * @return the value value.
     */
    public List<MetricInner> value() {
        return this.value;
    }

    /**
     * Set the value property: the value of the collection.
     * 
     * @param value the value value to set.
     * @return the ResponseInner object itself.
     */
    public ResponseInner withValue(List<MetricInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (timespan() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property timespan in model ResponseInner"));
        }
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model ResponseInner"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ResponseInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timespan", this.timespan);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("cost", this.cost);
        jsonWriter.writeStringField("interval", CoreUtils.durationToStringWithDays(this.interval));
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeStringField("resourceregion", this.resourceRegion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponseInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponseInner.
     */
    public static ResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponseInner deserializedResponseInner = new ResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timespan".equals(fieldName)) {
                    deserializedResponseInner.timespan = reader.getString();
                } else if ("value".equals(fieldName)) {
                    List<MetricInner> value = reader.readArray(reader1 -> MetricInner.fromJson(reader1));
                    deserializedResponseInner.value = value;
                } else if ("cost".equals(fieldName)) {
                    deserializedResponseInner.cost = reader.getNullable(JsonReader::getInt);
                } else if ("interval".equals(fieldName)) {
                    deserializedResponseInner.interval
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("namespace".equals(fieldName)) {
                    deserializedResponseInner.namespace = reader.getString();
                } else if ("resourceregion".equals(fieldName)) {
                    deserializedResponseInner.resourceRegion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResponseInner;
        });
    }
}
