// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.AccessModeSettings;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties that define a Azure Monitor PrivateLinkScope resource. */
@Fluent
public final class AzureMonitorPrivateLinkScopeProperties {
    /*
     * Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is
     * defined. Users cannot change this value but are able to read from it. Values will include Provisioning
     * ,Succeeded, Canceled and Failed.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /*
     * List of private endpoint connections.
     */
    @JsonProperty(value = "privateEndpointConnections", access = JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    /*
     * Access mode settings
     */
    @JsonProperty(value = "accessModeSettings", required = true)
    private AccessModeSettings accessModeSettings;

    /** Creates an instance of AzureMonitorPrivateLinkScopeProperties class. */
    public AzureMonitorPrivateLinkScopeProperties() {
    }

    /**
     * Get the provisioningState property: Current state of this PrivateLinkScope: whether or not is has been
     * provisioned within the resource group it is defined. Users cannot change this value but are able to read from it.
     * Values will include Provisioning ,Succeeded, Canceled and Failed.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connections.
     *
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Get the accessModeSettings property: Access mode settings.
     *
     * @return the accessModeSettings value.
     */
    public AccessModeSettings accessModeSettings() {
        return this.accessModeSettings;
    }

    /**
     * Set the accessModeSettings property: Access mode settings.
     *
     * @param accessModeSettings the accessModeSettings value to set.
     * @return the AzureMonitorPrivateLinkScopeProperties object itself.
     */
    public AzureMonitorPrivateLinkScopeProperties withAccessModeSettings(AccessModeSettings accessModeSettings) {
        this.accessModeSettings = accessModeSettings;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
        if (accessModeSettings() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property accessModeSettings in model"
                            + " AzureMonitorPrivateLinkScopeProperties"));
        } else {
            accessModeSettings().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureMonitorPrivateLinkScopeProperties.class);
}
