/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.MonitorManager;
import com.azure.resourcemanager.monitor.fluent.MonitorClient;
import com.azure.resourcemanager.monitor.fluent.models.DiagnosticSettingsResourceInner;
import com.azure.resourcemanager.monitor.models.CategoryType;
import com.azure.resourcemanager.monitor.models.DiagnosticSetting;
import com.azure.resourcemanager.monitor.models.DiagnosticSettingsCategory;
import com.azure.resourcemanager.monitor.models.LogSettings;
import com.azure.resourcemanager.monitor.models.MetricSettings;
import com.azure.resourcemanager.monitor.models.RetentionPolicy;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import reactor.core.publisher.Mono;

class DiagnosticSettingImpl
extends CreatableUpdatableImpl<DiagnosticSetting, DiagnosticSettingsResourceInner, DiagnosticSettingImpl>
implements DiagnosticSetting,
DiagnosticSetting.Definition,
DiagnosticSetting.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    public static final String DIAGNOSTIC_SETTINGS_URI = "/providers/microsoft.insights/diagnosticSettings/";
    private String resourceId;
    private TreeMap<String, MetricSettings> metricSet;
    private TreeMap<String, LogSettings> logSet;
    private TreeMap<String, LogSettings> logCategoryGroupSet;
    private final MonitorManager myManager;

    DiagnosticSettingImpl(String name, DiagnosticSettingsResourceInner innerModel, MonitorManager monitorManager) {
        super(name, (Object)innerModel);
        this.myManager = monitorManager;
        this.initializeSets();
    }

    @Override
    public DiagnosticSettingImpl withResource(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Override
    public DiagnosticSettingImpl withStorageAccount(String storageAccountId) {
        ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withLogAnalytics(String workspaceId) {
        ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).withWorkspaceId(workspaceId);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutLogAnalytics() {
        ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).withWorkspaceId(null);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutStorageAccount() {
        ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).withStorageAccountId(null);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withEventHub(String eventHubAuthorizationRuleId) {
        ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).withEventHubAuthorizationRuleId(eventHubAuthorizationRuleId);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withEventHub(String eventHubAuthorizationRuleId, String eventHubName) {
        this.withEventHub(eventHubAuthorizationRuleId);
        ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).withEventHubName(eventHubName);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutEventHub() {
        ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).withEventHubAuthorizationRuleId(null);
        ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).withEventHubName(null);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withMetric(String category, Duration timeGrain, int retentionDays) {
        MetricSettings nm = new MetricSettings();
        nm.withCategory(category);
        nm.withEnabled(true);
        nm.withRetentionPolicy(new RetentionPolicy());
        nm.retentionPolicy().withDays(retentionDays);
        if (retentionDays > 0) {
            nm.retentionPolicy().withEnabled(true);
        }
        nm.withTimeGrain(timeGrain);
        this.metricSet.put(category, nm);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withLog(String category, int retentionDays) {
        LogSettings nl = new LogSettings();
        nl.withCategory(category);
        nl.withEnabled(true);
        nl.withRetentionPolicy(new RetentionPolicy());
        nl.retentionPolicy().withDays(retentionDays);
        if (retentionDays > 0) {
            nl.retentionPolicy().withEnabled(true);
        }
        this.logSet.put(category, nl);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withLogsAndMetrics(List<DiagnosticSettingsCategory> categories, Duration timeGrain, int retentionDays) {
        for (DiagnosticSettingsCategory dsc : categories) {
            if (dsc.type() == CategoryType.METRICS) {
                this.withMetric(dsc.name(), timeGrain, retentionDays);
                continue;
            }
            if (dsc.type() == CategoryType.LOGS) {
                this.withLog(dsc.name(), retentionDays);
                continue;
            }
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(dsc.type().toString() + " is unsupported."));
        }
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutMetric(String category) {
        this.metricSet.remove(category);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutLog(String category) {
        this.logSet.remove(category);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutLogs() {
        this.logSet.clear();
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutMetrics() {
        this.metricSet.clear();
        return this;
    }

    public String id() {
        return ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).id();
    }

    @Override
    public String resourceId() {
        return this.resourceId;
    }

    @Override
    public String storageAccountId() {
        return ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).storageAccountId();
    }

    @Override
    public String eventHubAuthorizationRuleId() {
        return ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).eventHubAuthorizationRuleId();
    }

    @Override
    public String eventHubName() {
        return ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).eventHubName();
    }

    @Override
    public List<MetricSettings> metrics() {
        if (((DiagnosticSettingsResourceInner)((Object)this.innerModel())).metrics() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(((DiagnosticSettingsResourceInner)((Object)this.innerModel())).metrics());
    }

    @Override
    public List<LogSettings> logs() {
        if (((DiagnosticSettingsResourceInner)((Object)this.innerModel())).logs() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(((DiagnosticSettingsResourceInner)((Object)this.innerModel())).logs());
    }

    @Override
    public String workspaceId() {
        return ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).workspaceId();
    }

    public MonitorManager manager() {
        return this.myManager;
    }

    public boolean isInCreateMode() {
        return ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).id() == null;
    }

    public Mono<DiagnosticSetting> createResourceAsync() {
        ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).withLogs(new ArrayList<LogSettings>(this.logSet.values()));
        ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).withLogs(new ArrayList<LogSettings>(this.logCategoryGroupSet.values()));
        ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).withMetrics(new ArrayList<MetricSettings>(this.metricSet.values()));
        return ((MonitorClient)this.manager().serviceClient()).getDiagnosticSettingsOperations().createOrUpdateAsync(this.resourceId, this.name(), (DiagnosticSettingsResourceInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<DiagnosticSettingsResourceInner> getInnerAsync() {
        return ((MonitorClient)this.manager().serviceClient()).getDiagnosticSettingsOperations().getAsync(this.resourceId, this.name());
    }

    public void setInner(DiagnosticSettingsResourceInner inner) {
        super.setInner((Object)inner);
        this.initializeSets();
        this.metricSet.clear();
        this.logSet.clear();
        if (!this.isInCreateMode()) {
            this.resourceId = inner.id().substring(0, ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).id().length() - (DIAGNOSTIC_SETTINGS_URI + ((DiagnosticSettingsResourceInner)((Object)this.innerModel())).name()).length());
            for (MetricSettings ms : this.metrics()) {
                if (ms.category() == null) continue;
                this.metricSet.put(ms.category(), ms);
            }
            for (LogSettings ls : this.logs()) {
                if (ls.category() != null) {
                    this.logSet.put(ls.category(), ls);
                    continue;
                }
                if (ls.categoryGroup() == null) continue;
                this.logCategoryGroupSet.put(ls.categoryGroup(), ls);
            }
        }
    }

    private void initializeSets() {
        if (this.metricSet == null) {
            this.metricSet = new TreeMap();
        }
        if (this.logSet == null) {
            this.logSet = new TreeMap();
        }
        if (this.logCategoryGroupSet == null) {
            this.logCategoryGroupSet = new TreeMap();
        }
    }
}

