/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.SkuFamily;
import com.azure.resourcemanager.keyvault.models.SkuName;
import java.io.IOException;

public final class Sku
implements JsonSerializable<Sku> {
    private SkuFamily family = SkuFamily.A;
    private SkuName name;
    private static final ClientLogger LOGGER = new ClientLogger(Sku.class);

    public SkuFamily family() {
        return this.family;
    }

    public Sku withFamily(SkuFamily family) {
        this.family = family;
        return this;
    }

    public SkuName name() {
        return this.name;
    }

    public Sku withName(SkuName name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.family() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property family in model Sku"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model Sku"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("family", this.family == null ? null : this.family.toString());
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static Sku fromJson(JsonReader jsonReader) throws IOException {
        return (Sku)jsonReader.readObject(reader -> {
            Sku deserializedSku = new Sku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("family".equals(fieldName)) {
                    deserializedSku.family = SkuFamily.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSku.name = SkuName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSku;
        });
    }
}

