/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.ManagedHsmKeyRotationPolicyAttributes;
import com.azure.resourcemanager.keyvault.models.ManagedHsmLifetimeAction;
import java.io.IOException;
import java.util.List;

public final class ManagedHsmRotationPolicy
implements JsonSerializable<ManagedHsmRotationPolicy> {
    private ManagedHsmKeyRotationPolicyAttributes attributes;
    private List<ManagedHsmLifetimeAction> lifetimeActions;

    public ManagedHsmKeyRotationPolicyAttributes attributes() {
        return this.attributes;
    }

    public ManagedHsmRotationPolicy withAttributes(ManagedHsmKeyRotationPolicyAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public List<ManagedHsmLifetimeAction> lifetimeActions() {
        return this.lifetimeActions;
    }

    public ManagedHsmRotationPolicy withLifetimeActions(List<ManagedHsmLifetimeAction> lifetimeActions) {
        this.lifetimeActions = lifetimeActions;
        return this;
    }

    public void validate() {
        if (this.attributes() != null) {
            this.attributes().validate();
        }
        if (this.lifetimeActions() != null) {
            this.lifetimeActions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeArrayField("lifetimeActions", this.lifetimeActions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedHsmRotationPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedHsmRotationPolicy)jsonReader.readObject(reader -> {
            ManagedHsmRotationPolicy deserializedManagedHsmRotationPolicy = new ManagedHsmRotationPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("attributes".equals(fieldName)) {
                    deserializedManagedHsmRotationPolicy.attributes = ManagedHsmKeyRotationPolicyAttributes.fromJson(reader);
                    continue;
                }
                if ("lifetimeActions".equals(fieldName)) {
                    List lifetimeActions;
                    deserializedManagedHsmRotationPolicy.lifetimeActions = lifetimeActions = reader.readArray(reader1 -> ManagedHsmLifetimeAction.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedHsmRotationPolicy;
        });
    }
}

